package org.elsfs.tool.core.page;

import java.util.Collections;
import java.util.List;

/**
 * the is {@link Page}
 *
 * @author zeng
 * @version 0.0.4
 */
public class Page<T> implements IPage<T> {
  protected List<T> records;
  protected long total;
  protected long size;
  protected long current;

  public Page() {
    this.records = Collections.emptyList();
    this.total = 0L;
    this.size = 10L;
    this.current = 1L;

  }

  public Page(long current, long size) {
    this(current, size, 0L);
  }

  public Page(long current, long size, long total) {
    this(current, size, total, true);
  }

  public Page(long current, long size, boolean searchCount) {
    this(current, size, 0L, searchCount);
  }

  public Page(long current, long size, long total, boolean searchCount) {
    this.records = Collections.emptyList();
    this.total = 0L;
    this.size = 10L;
    this.current = 1L;

    if (current > 1L) {
      this.current = current;
    }
    this.size = size;
    this.total = total;
  }


  /**
   * 设置当前分页数
   *
   * @param current 当前分页数
   */
  @Override
  public void setCurrent(long current) {
    this.current=current;
  }

  /**
   * 获取当前分页数
   *
   * @return 当前分页数
   */
  @Override
  public long getCurrent() {
    return current;
  }

  /**
   * 设置分页大小
   *
   * @param size 分页大小
   */
  @Override
  public void setSize(long size) {
  this.size = size;
  }

  /**
   * 获取分页大小
   *
   * @return 分页大小
   */
  @Override
  public long getSize() {
    return size;
  }

  /**
   * 设置获取总记录数
   *
   * @param total 总记录数
   */
  @Override
  public void setTotal(long total) {
    this.total = total;
  }

  /**
   * 获取总记录数
   *
   * @return 总记录数
   */
  @Override
  public long getTotal() {
    return total;
  }

  /**
   * 获取 分页数据
   *
   * @return 分页数据
   */
  @Override
  public List<T> getRecords() {
    return records;
  }

  /**
   * 设置 分页数据
   *
   * @param records 数据
   */
  @Override
  public void setRecords(List<T> records) {
    this.records = records;
  }



  /**
   * 分页大小
   *
   * @return 分页大小
   */
  @Override
  public long getPageSize() {
    return size;
  }
}
