package org.elsfs.tool.core.text;

/**
 * the is {@link StringUtils}
 *
 * @author zeng
 * @since 0.0.3
 */
public class StringUtils {

  /**
   * Check if the String is null or has only whitespaces.
   *
   * <p>Modified from {@code org.apache.commons.lang.StringUtils#isBlank(String)}.
   *
   * @param string String to check
   * @return {@code true} if the String is null or has only whitespaces
   */
  public static boolean isBlank(String string) {
    if (isEmpty(string)) {
      return true;
    }
    for (int i = 0; i < string.length(); i++) {
      if (!Character.isWhitespace(string.charAt(i))) {
        return false;
      }
    }
    return true;
  }

  /**
   * Check if the String is not blank.
   *
   * @param string String to check
   * @return {@code true} if the String is not blank
   */
  public static boolean isNotBlank(String string) {
    return !isBlank(string);
  }

  /**
   * Check if the String is null or empty.
   *
   * @param string String to check
   * @return {@code true} if the String is null or empty
   */
  public static boolean isEmpty(String string) {
    return string == null || string.isEmpty();
  }
}
