/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elsfs.tool.core.tree.Tree;
import org.elsfs.tool.core.tree.TreeBuilder;
import org.elsfs.tool.core.tree.TreeNode;
import org.elsfs.tool.core.tree.TreeNodeConfig;
import org.elsfs.tool.core.tree.parser.DefaultNodeParser;
import org.elsfs.tool.core.tree.parser.NodeParser;
import org.elsfs.tool.core.util.CollectionUtils;

public class TreeUtil {
    public static List<Tree<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeUtil.build(list, Integer.valueOf(0));
    }

    public static <E> List<Tree<E>> build(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list, rootId, treeNodeConfig, nodeParser).getChildren();
    }

    public static <E> List<Tree<E>> build(Map<E, Tree<E>> map, E rootId) {
        return TreeUtil.buildSingle(map, rootId).getChildren();
    }

    public static Tree<Integer> buildSingle(List<TreeNode<Integer>> list) {
        return TreeUtil.buildSingle(list, Integer.valueOf(0));
    }

    public static <E> Tree<E> buildSingle(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.buildSingle(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> Tree<E> buildSingle(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> Tree<E> buildSingle(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeBuilder.of(rootId, treeNodeConfig).append(list, rootId, nodeParser).build();
    }

    public static <E> Tree<E> buildSingle(Map<E, Tree<E>> map, E rootId) {
        Tree<E> tree = CollectionUtils.getFirstNoneNull(map.values());
        if (null != tree) {
            TreeNodeConfig config = tree.getConfig();
            return TreeBuilder.of(rootId, config).append(map).build();
        }
        return TreeUtil.createEmptyNode(rootId);
    }

    public static <T> Tree<T> getNode(Tree<T> node, T id) {
        if (Objects.equals(id, node.getId())) {
            return node;
        }
        List<Tree<T>> children = node.getChildren();
        if (null == children) {
            return null;
        }
        for (Tree<T> child : children) {
            Tree<T> childNode = child.getNode(id);
            if (null == childNode) continue;
            return childNode;
        }
        return null;
    }

    public static <T> List<CharSequence> getParentsName(Tree<T> node, boolean includeCurrentNode) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        if (null == node) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(node.getName());
        }
        for (Tree<T> parent = node.getParent(); null != parent; parent = parent.getParent()) {
            result.add(parent.getName());
        }
        return result;
    }

    public static <E> Tree<E> createEmptyNode(E id) {
        return new Tree().setId(id);
    }
}

