/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.util;

import org.elsfs.tool.core.text.CharUtil;

public class CharSequenceUtil {
    public static final String EMPTY = "";

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtil.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String upperFirst(CharSequence str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + CharSequenceUtil.subSuf(str, 1);
        }
        return str.toString();
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (CharSequenceUtil.isEmpty(string)) {
            return null;
        }
        return CharSequenceUtil.sub(string, fromIndex, string.length());
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return EMPTY;
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return CharSequenceUtil.equals(str1, str2, false);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static String strip(CharSequence str, CharSequence prefixOrSuffix) {
        if (CharSequenceUtil.equals(str, prefixOrSuffix)) {
            return EMPTY;
        }
        return CharSequenceUtil.strip(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String strip(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (CharSequenceUtil.startWith(str2, prefix)) {
            from = prefix.length();
        }
        if (CharSequenceUtil.endWith(str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(Math.min(from, to), Math.max(from, to));
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefixOrSuffix) {
        return CharSequenceUtil.stripIgnoreCase(str, prefixOrSuffix, prefixOrSuffix);
    }

    public static String stripIgnoreCase(CharSequence str, CharSequence prefix, CharSequence suffix) {
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (CharSequenceUtil.startWithIgnoreCase(str2, prefix)) {
            from = prefix.length();
        }
        if (CharSequenceUtil.endWithIgnoreCase(str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.startWith(str, prefix, false);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        return CharSequenceUtil.startWith(str, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == str || null == prefix) {
            if (ignoreEquals) {
                return false;
            }
            return null == str && null == prefix;
        }
        boolean isStartWith = str.toString().regionMatches(ignoreCase, 0, prefix.toString(), 0, prefix.length());
        if (isStartWith) {
            return false == ignoreEquals || false == CharSequenceUtil.equals(str, prefix, ignoreCase);
        }
        return false;
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return CharSequenceUtil.startWith(str, prefix, true);
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.endWith(str, suffix, true);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return CharSequenceUtil.endWith(str, suffix, false);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        return CharSequenceUtil.endWith(str, suffix, ignoreCase, false);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == str || null == suffix) {
            if (ignoreEquals) {
                return false;
            }
            return null == str && null == suffix;
        }
        int strOffset = str.length() - suffix.length();
        boolean isEndWith = str.toString().regionMatches(ignoreCase, strOffset, suffix.toString(), 0, suffix.length());
        if (isEndWith) {
            return false == ignoreEquals || false == CharSequenceUtil.equals(str, suffix, ignoreCase);
        }
        return false;
    }
}

