/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class CollectionUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtils.isEmpty(map);
    }

    public static <T> T getFirstNoneNull(Iterable<T> iterable) {
        if (null == iterable) {
            return null;
        }
        return CollectionUtils.getFirstNoneNull(iterable.iterator());
    }

    public static <T> T getFirstNoneNull(Iterator<T> iterator) {
        return (T)CollectionUtils.firstMatch(iterator, Objects::nonNull);
    }

    public static <T> T firstMatch(Iterator<T> iterator, Function<T, Boolean> matcher) {
        Objects.requireNonNull(matcher, "Matcher must be not null !");
        if (null != iterator) {
            while (iterator.hasNext()) {
                T next = iterator.next();
                if (!matcher.apply(next).booleanValue()) continue;
                return next;
            }
        }
        return null;
    }
}

