/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.util;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.elsfs.tool.core.text.ArrayUtils;

public class ReflectUtil {
    public static final ConcurrentMap<Class<?>, Field[]> FIELDS_CACHE = new ConcurrentHashMap();

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        return FIELDS_CACHE.computeIfAbsent(beanClass, b -> ReflectUtil.getFieldsDirectly(beanClass, true));
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : ArrayUtils.append(allFields, declaredFields);
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }
}

