package org.elsfs.tool.core.util;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.elsfs.tool.core.text.ArrayUtils;

/**
 * the is {@link ReflectUtil}
 *
 * @author zeng
 * @since 0.0.3
 */
public class ReflectUtil {
  // 字段缓存
  public static final ConcurrentMap<Class<?>, Field[]> FIELDS_CACHE = new ConcurrentHashMap<>();

  /**
   * 获得一个类中所有字段列表，包括其父类中的字段<br>
   * 如果子类与父类中存在同名字段，则这两个字段同时存在，子类字段在前，父类字段在后。
   *
   * @param beanClass 类
   * @return 字段列表
   * @throws SecurityException 安全检查异常
   */
  public static Field[] getFields(Class<?> beanClass) throws SecurityException {
    return FIELDS_CACHE.computeIfAbsent(beanClass, b -> getFieldsDirectly(beanClass, true));
  }

  /**
   * 获得一个类中所有字段列表，直接反射获取，无缓存<br>
   * 如果子类与父类中存在同名字段，则这两个字段同时存在，子类字段在前，父类字段在后。
   *
   * @param beanClass 类
   * @param withSuperClassFields 是否包括父类的字段列表
   * @return 字段列表
   * @throws SecurityException 安全检查异常
   */
  public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields)
      throws SecurityException {
    Field[] allFields = null;
    Class<?> searchType = beanClass;
    Field[] declaredFields;
    while (searchType != null) {
      declaredFields = searchType.getDeclaredFields();
      if (null == allFields) {
        allFields = declaredFields;
      } else {
        allFields = ArrayUtils.append(allFields, declaredFields);
      }
      searchType = withSuperClassFields ? searchType.getSuperclass() : null;
    }

    return allFields;
  }
}
