/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.tree;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elsfs.tool.core.tree.Node;
import org.elsfs.tool.core.tree.TreeNodeConfig;
import org.elsfs.tool.core.tree.TreeUtil;
import org.elsfs.tool.core.util.CollectionUtils;

public class Tree<T>
extends LinkedHashMap<String, Object>
implements Node<T> {
    private static final long serialVersionUID = 1L;
    private final TreeNodeConfig treeNodeConfig;
    private Tree<T> parent;

    public Tree() {
        this((TreeNodeConfig)null);
    }

    public Tree(TreeNodeConfig treeNodeConfig) {
        this.treeNodeConfig = Objects.requireNonNullElse(treeNodeConfig, TreeNodeConfig.DEFAULT_CONFIG);
    }

    public TreeNodeConfig getConfig() {
        return this.treeNodeConfig;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public Tree<T> getNode(T id) {
        return TreeUtil.getNode(this, id);
    }

    public List<CharSequence> getParentsName(T id, boolean includeCurrentNode) {
        return TreeUtil.getParentsName(this.getNode(id), includeCurrentNode);
    }

    public List<CharSequence> getParentsName(boolean includeCurrentNode) {
        return TreeUtil.getParentsName(this, includeCurrentNode);
    }

    public Tree<T> setParent(Tree<T> parent) {
        this.parent = parent;
        if (null != parent) {
            this.setParentId((Object)parent.getId());
        }
        return this;
    }

    @Override
    public T getId() {
        return (T)this.get(this.treeNodeConfig.getIdKey());
    }

    @Override
    public Tree<T> setId(T id) {
        this.put(this.treeNodeConfig.getIdKey(), id);
        return this;
    }

    @Override
    public T getParentId() {
        return (T)this.get(this.treeNodeConfig.getParentIdKey());
    }

    @Override
    public Tree<T> setParentId(T parentId) {
        this.put(this.treeNodeConfig.getParentIdKey(), parentId);
        return this;
    }

    @Override
    public CharSequence getName() {
        return (CharSequence)this.get(this.treeNodeConfig.getNameKey());
    }

    @Override
    public Tree<T> setName(CharSequence name) {
        this.put(this.treeNodeConfig.getNameKey(), name);
        return this;
    }

    @Override
    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.treeNodeConfig.getWeightKey());
    }

    @Override
    public Tree<T> setWeight(Comparable<?> weight) {
        this.put(this.treeNodeConfig.getWeightKey(), weight);
        return this;
    }

    public List<Tree<T>> getChildren() {
        return (List)this.get(this.treeNodeConfig.getChildrenKey());
    }

    public boolean hasChild() {
        return CollectionUtils.isNotEmpty(this.getChildren());
    }

    public void walk(Consumer<Tree<T>> consumer) {
        consumer.accept(this);
        List<Tree<Tree>> children = this.getChildren();
        if (CollectionUtils.isNotEmpty(children)) {
            children.forEach((? super T tree) -> tree.walk(consumer));
        }
    }

    public Tree<T> filterNew(Function<Tree<T>, Boolean> filter) {
        return this.cloneTree().filter(filter);
    }

    public Tree<T> filter(Function<Tree<T>, Boolean> filter) {
        if (filter.apply(this).booleanValue()) {
            return this;
        }
        List<Tree<T>> children = this.getChildren();
        if (CollectionUtils.isNotEmpty(children)) {
            ArrayList<Tree<T>> filteredChildren = new ArrayList<Tree<T>>(children.size());
            for (Tree<Tree<Tree>> tree : children) {
                Tree<T> filteredChild = tree.filter(filter);
                if (null == filteredChild) continue;
                filteredChildren.add(filteredChild);
            }
            if (CollectionUtils.isNotEmpty(filteredChildren)) {
                return this.setChildren(filteredChildren);
            }
            this.setChildren(null);
        }
        return null;
    }

    public Tree<T> setChildren(List<Tree<T>> children) {
        if (null == children) {
            this.remove(this.treeNodeConfig.getChildrenKey());
        }
        this.put(this.treeNodeConfig.getChildrenKey(), children);
        return this;
    }

    @SafeVarargs
    public final Tree<T> addChildren(Tree<T> ... children) {
        if (children != null && children.length > 0) {
            List<Tree<T>> childrenList = this.getChildren();
            if (null == childrenList) {
                childrenList = new ArrayList<Tree<T>>();
                this.setChildren(childrenList);
            }
            for (Tree<T> child : children) {
                child.setParent(this);
                childrenList.add(child);
            }
        }
        return this;
    }

    public void putExtra(String key, Object value) {
        Objects.requireNonNull(key, "Key must be not empty !");
        this.put(key, value);
    }

    public Tree<T> cloneTree() {
        Tree result = (Tree)this.clone();
        result.setChildren(this.cloneChildren());
        return result;
    }

    private List<Tree<T>> cloneChildren() {
        List<Tree<Tree>> children = this.getChildren();
        if (null == children) {
            return null;
        }
        ArrayList newChildren = new ArrayList(children.size());
        children.forEach((? super T t) -> newChildren.add(t.cloneTree()));
        return newChildren;
    }
}

