/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;

public class ClassUtils {
    public static ArrayList<Field> getDeclaredFields(Class<?> classes) {
        return ClassUtils.getDeclaredFields(classes, true);
    }

    public static ArrayList<Field> getDeclaredFields(Class<?> classes, boolean isContainSuper) {
        Class<?> superclass;
        ArrayList<Field> fields = new ArrayList<Field>();
        if (classes == null) {
            return fields;
        }
        fields.addAll(Arrays.stream(classes.getDeclaredFields()).toList());
        if (isContainSuper && (superclass = classes.getSuperclass()) != null) {
            ArrayList<Field> list = ClassUtils.getDeclaredFields(superclass);
            if (list.isEmpty()) {
                return fields;
            }
            fields.addAll(list);
        }
        return fields;
    }

    public static Class<?> getSuperclass(Class<?> classes) {
        return classes == null ? null : classes.getSuperclass();
    }

    public static boolean isInterface(Class<?> classes) {
        return classes != null && classes.isInterface();
    }

    public static Class<?>[] getClassOfParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] subTypes = pt.getActualTypeArguments();
            Class[] classes = new Class[subTypes.length];
            for (int i = 0; i < subTypes.length; ++i) {
                Class clazz;
                classes[i] = clazz = (Class)((ParameterizedType)subTypes[i]).getRawType();
            }
            return classes;
        }
        return null;
    }

    public static Class<?> getClassOfParameterizedType(Type type, int index) {
        Class<?>[] classes = ClassUtils.getClassOfParameterizedType(type);
        if (classes == null || classes.length == 0 || classes.length < index) {
            return null;
        }
        return classes[index];
    }
}

