/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.comcord.validators;

import javax.enterprise.context.ApplicationScoped;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import org.elypia.comcord.constraints.Everyone;

@ApplicationScoped
public class EveryoneMessageValidator
implements ConstraintValidator<Everyone, Message> {
    public boolean isValid(Message message, ConstraintValidatorContext context) {
        if (!message.isFromGuild()) {
            return true;
        }
        Member member = message.getMember();
        if (member == null) {
            throw new IllegalStateException("Obtained null member from a message in a guild.");
        }
        TextChannel channel = message.getTextChannel();
        if (member.hasPermission((GuildChannel)channel, new Permission[]{Permission.MESSAGE_MENTION_EVERYONE})) {
            return true;
        }
        return message.mentionsEveryone();
    }
}

