/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.comcord.validators;

import javax.enterprise.context.ApplicationScoped;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import org.elypia.comcord.constraints.Permissions;

@ApplicationScoped
public class PermissionMessageValidator
implements ConstraintValidator<Permissions, Message> {
    private Permission[] permissions;
    private boolean userNeedsPermission;

    public void initialize(Permissions constraintAnnotation) {
        this.permissions = constraintAnnotation.value();
        this.userNeedsPermission = constraintAnnotation.userNeedsPermission();
    }

    public boolean isValid(Message message, ConstraintValidatorContext context) {
        if (!message.isFromGuild()) {
            throw new IllegalStateException("Permission validation check can not be used in DMs.");
        }
        Guild guild = message.getGuild();
        TextChannel channel = message.getTextChannel();
        if (!guild.getSelfMember().hasPermission((GuildChannel)channel, this.permissions)) {
            return false;
        }
        if (!this.userNeedsPermission) {
            return true;
        }
        Member member = message.getMember();
        if (member == null) {
            throw new IllegalStateException("Non-null message with non-null guild returned null author.");
        }
        return member.hasPermission((GuildChannel)channel, this.permissions);
    }
}

