/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.comcord.validators;

import javax.enterprise.context.ApplicationScoped;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import org.elypia.comcord.constraints.Permissions;

@ApplicationScoped
public class PermissionsMemberValidator
implements ConstraintValidator<Permissions, Member> {
    private Permission[] permissions;
    private boolean userNeedsPermission;

    public void initialize(Permissions constraintAnnotation) {
        this.permissions = constraintAnnotation.value();
        this.userNeedsPermission = constraintAnnotation.userNeedsPermission();
    }

    public boolean isValid(Member member, ConstraintValidatorContext context) {
        Guild guild = member.getGuild();
        if (!guild.getSelfMember().hasPermission(this.permissions)) {
            return false;
        }
        if (!this.userNeedsPermission) {
            return true;
        }
        return member.hasPermission(this.permissions);
    }
}

