/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.comcord.validators.cdi;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.ApplicationInfo;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import org.elypia.comcord.constraints.BotOwner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BotOwnerMessageValidator
implements ConstraintValidator<BotOwner, Message> {
    private static final Logger logger = LoggerFactory.getLogger(BotOwnerMessageValidator.class);
    private final CompletableFuture<ApplicationInfo> future;
    private Long ownerId;

    @Inject
    public BotOwnerMessageValidator(JDA jda) {
        this.future = jda.retrieveApplicationInfo().submit();
    }

    public void initialize(BotOwner elevated) {
        try {
            this.ownerId = this.future.get().getOwner().getIdLong();
        }
        catch (Exception ex) {
            logger.error("Failed to obtain application owner ID, will be unvalidate if it's the owner.", (Throwable)ex);
        }
    }

    public boolean isValid(Message message, ConstraintValidatorContext context) {
        if (this.ownerId == null) {
            return false;
        }
        User user = message.getAuthor();
        boolean isValid = user.getIdLong() == this.ownerId.longValue();
        logger.info("A command reserved for bot owners was attemped at {} by the user {}, returned {}.", new Object[]{Instant.now(), user, isValid});
        return isValid;
    }
}

