/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.comcord.validators.cdi;

import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ApplicationInfo;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import org.elypia.comcord.constraints.Elevated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ElevatedMemberValidator
implements ConstraintValidator<Elevated, Member> {
    private static final Logger logger = LoggerFactory.getLogger(ElevatedMemberValidator.class);
    private final CompletableFuture<ApplicationInfo> future;
    private Long ownerId;

    @Inject
    public ElevatedMemberValidator(JDA jda) {
        this.future = jda.retrieveApplicationInfo().submit();
    }

    public void initialize(Elevated elevated) {
        try {
            this.ownerId = this.future.get().getOwner().getIdLong();
        }
        catch (Exception ex) {
            logger.error("Failed to obtain application owner ID, will be unvalidate if it's the owner.", (Throwable)ex);
        }
    }

    public boolean isValid(Member member, ConstraintValidatorContext context) {
        if (member.hasPermission(new Permission[]{Permission.MANAGE_SERVER})) {
            return true;
        }
        if (this.ownerId == null) {
            return false;
        }
        User user = member.getUser();
        return user.getIdLong() == this.ownerId.longValue();
    }
}

