/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.comcord.validators.cdi;

import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ApplicationInfo;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import org.elypia.comcord.constraints.Elevated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ElevatedMessageValidator
implements ConstraintValidator<Elevated, Message> {
    private static final Logger logger = LoggerFactory.getLogger(ElevatedMessageValidator.class);
    private final CompletableFuture<ApplicationInfo> future;
    private Long ownerId;

    @Inject
    public ElevatedMessageValidator(JDA jda) {
        this.future = jda.retrieveApplicationInfo().submit();
    }

    public void initialize(Elevated elevated) {
        try {
            this.ownerId = this.future.get().getOwner().getIdLong();
        }
        catch (Exception ex) {
            logger.error("Failed to obtain application owner ID, will be unvalidate if it's the owner.", (Throwable)ex);
        }
    }

    public boolean isValid(Message message, ConstraintValidatorContext context) {
        if (!message.isFromGuild()) {
            return true;
        }
        Member member = message.getMember();
        if (member == null) {
            throw new IllegalStateException("Non-null message and non-null guild returned null member.");
        }
        TextChannel channel = message.getTextChannel();
        if (member.hasPermission((GuildChannel)channel, new Permission[]{Permission.MANAGE_SERVER})) {
            return true;
        }
        if (this.ownerId == null) {
            return false;
        }
        User user = member.getUser();
        return user.getIdLong() == this.ownerId.longValue();
    }
}

