/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.commandler.newb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elypia.commandler.CommandlerExtension;
import org.elypia.commandler.annotation.Param;
import org.elypia.commandler.dispatchers.standard.StandardCommand;
import org.elypia.commandler.dispatchers.standard.StandardController;
import org.elypia.commandler.i18n.CommandlerMessageResolver;
import org.elypia.commandler.metadata.MetaCommand;
import org.elypia.commandler.metadata.MetaComponent;
import org.elypia.commandler.metadata.MetaController;
import org.elypia.commandler.metadata.MetaParam;
import org.elypia.commandler.models.AllGroupsModel;
import org.elypia.commandler.models.CommandModel;
import org.elypia.commandler.models.ControllerModel;
import org.elypia.commandler.models.GroupModel;
import org.elypia.commandler.models.ParamModel;
import org.elypia.commandler.models.PropertyModel;

@StandardController
public class DefaultHelpController {
    protected final CommandlerExtension commandlerExtension;
    protected final CommandlerMessageResolver messageResolver;

    @Inject
    public DefaultHelpController(CommandlerExtension commandlerExtension, CommandlerMessageResolver messageResolver) {
        this.commandlerExtension = commandlerExtension;
        this.messageResolver = messageResolver;
    }

    @StandardCommand(isDefault=true)
    public AllGroupsModel getAllGroups() {
        HashMap groups = new HashMap();
        Collection allControllers = this.commandlerExtension.getMetaControllers().stream().filter(MetaController::isPublic).map(this::getControllerHelp).collect(Collectors.toList());
        for (ControllerModel controllerModel : allControllers) {
            String group = this.messageResolver.getMessage(controllerModel.getGroup());
            if (!groups.containsKey(group)) {
                groups.put(group, new ArrayList());
            }
            ((List)groups.get(group)).add(controllerModel);
        }
        MetaController helpController = this.commandlerExtension.getMetaControllers().stream().filter(meta -> meta.getControllerType() == this.getClass()).findAny().get();
        ControllerModel helpModel = this.getControllerHelp(helpController);
        return new AllGroupsModel(helpModel, groups);
    }

    @StandardCommand
    public Object getGroup(@Param String query) {
        Collection controllers = this.commandlerExtension.getMetaControllers();
        List group = controllers.stream().filter(MetaController::isPublic).filter(c -> this.messageResolver.getMessage(c.getGroup()).equalsIgnoreCase(query)).map(this::getControllerHelp).collect(Collectors.toList());
        if (group.isEmpty()) {
            return "There is no group by the name.";
        }
        String groupName = ((ControllerModel)group.get(0)).getGroup();
        return new GroupModel(groupName, group);
    }

    @StandardCommand
    public ControllerModel getControllerHelp(@Param MetaController controller) {
        String controllerName = this.messageResolver.getMessage(controller.getName());
        String controllerDescription = this.messageResolver.getMessage(controller.getDescription());
        String controllerGroup = this.messageResolver.getMessage(controller.getGroup());
        ArrayList<CommandModel> commands = new ArrayList<CommandModel>();
        for (MetaCommand command : controller.getPublicCommands()) {
            String commandName = this.messageResolver.getMessage(command.getName());
            String commandDescription = this.messageResolver.getMessage(command.getDescription());
            ArrayList<ParamModel> params = new ArrayList<ParamModel>();
            for (MetaParam metaParam : command.getMetaParams()) {
                String paramName = this.messageResolver.getMessage(metaParam.getName());
                String paramDescription = this.messageResolver.getMessage(metaParam.getDescription());
                ParamModel paramModel = new ParamModel(paramName, paramDescription, this.getLocalizedPublicProperties((MetaComponent)metaParam));
                params.add(paramModel);
            }
            CommandModel commandModel = new CommandModel(commandName, commandDescription, params, this.getLocalizedPublicProperties((MetaComponent)command));
            commands.add(commandModel);
        }
        return new ControllerModel(controllerName, controllerDescription, controllerGroup, commands, this.getLocalizedPublicProperties((MetaComponent)controller));
    }

    protected List<PropertyModel> getLocalizedPublicProperties(MetaComponent metaComponent) {
        ArrayList<PropertyModel> properties = new ArrayList<PropertyModel>();
        metaComponent.getProperties().forEach((key, property) -> {
            if (!property.isPublic()) {
                return;
            }
            if (property.isI18n()) {
                properties.add(new PropertyModel(this.messageResolver.getMessage(property.getDisplayName()), this.messageResolver.getMessage(property.getValue())));
            } else {
                properties.add(new PropertyModel(property.getDisplayName(), property.getValue()));
            }
        });
        return properties;
    }
}

