/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.webhooker.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.elypia.webhooker.Client;
import org.elypia.webhooker.Dispatcher;
import org.elypia.webhooker.DispatcherSupplier;
import org.elypia.webhooker.controller.SuppliedClientController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;

public class RedisClientController
extends SuppliedClientController {
    private Jedis jedis;

    public RedisClientController(JedisShardInfo info) {
        this(new Jedis(info));
    }

    public RedisClientController(Jedis jedis) {
        this.jedis = jedis;
    }

    public Client add(Client client) {
        String key = client.getUuid().toString();
        String[] dispatchers = (String[])client.getCallbacks().stream().map(Dispatcher::getId).toArray(String[]::new);
        this.jedis.rpush(key, dispatchers);
        return client;
    }

    public Client get(UUID uuid) {
        String key = uuid.toString();
        List values = this.jedis.lrange(key, 0L, Long.MAX_VALUE).stream().map(arg_0 -> ((DispatcherSupplier)this.supplier).get(arg_0)).collect(Collectors.toUnmodifiableList());
        return new Client(uuid, values);
    }

    public Map<UUID, Client> getAll() {
        Set keys = this.jedis.keys("*");
        return keys.stream().map(arg_0 -> ((RedisClientController)this).get(arg_0)).collect(Collectors.toUnmodifiableMap(Client::getUuid, client -> client));
    }

    public Jedis getJedis() {
        return this.jedis;
    }
}

