/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.webservertestbed;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import okhttp3.mockwebserver.MockResponse;
import org.elypia.webservertestbed.api.ContentLoader;

public final class Mock {
    private static final int DEFAULT_RESPONSE_CODE = 200;

    private Mock() {
        throw new IllegalStateException("Don't construct this class.");
    }

    public static List<MockResponse> ofAll(String ... responseBodies) {
        ArrayList<MockResponse> responses = new ArrayList<MockResponse>();
        for (String responseBody : responseBodies) {
            MockResponse response = Mock.of(responseBody);
            responses.add(response);
        }
        return responses;
    }

    public static MockResponse of(String body) {
        return Mock.of(body, 200);
    }

    public static MockResponse of(String value, ContentLoader loader) throws IOException {
        return Mock.of(value, 200, loader);
    }

    public static MockResponse of(String value, int responseCode, Class<? extends ContentLoader> loaderType) throws IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        Constructor constructor = Stream.of(loaderType.getConstructors()).filter(c -> c.getParameterCount() == 0).findAny().orElseThrow(() -> new IllegalArgumentException("Can only construct ContentLoaders with a default constructor."));
        ContentLoader loader = (ContentLoader)constructor.newInstance(new Object[0]);
        return Mock.of(value, responseCode, loader);
    }

    public static MockResponse of(String value, int responseCode, ContentLoader loader) throws IOException {
        String content = loader.loadContent(value);
        return Mock.of(content, responseCode);
    }

    public static MockResponse of(String body, int responseCode) {
        return new MockResponse().setResponseCode(responseCode).setBody(body);
    }
}

