/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.webservertestbed;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class ResourceUtils {
    private ResourceUtils() {
        throw new IllegalStateException("Don't construct this class.");
    }

    public static InputStream getAsStream(String name) {
        Objects.requireNonNull(name);
        String path = File.separator + name;
        InputStream stream = ResourceUtils.class.getResourceAsStream(path);
        Objects.requireNonNull(stream, "Resource at `" + path + "` doesn't exist.");
        return stream;
    }

    public static byte[] getAsBytes(String name) throws IOException {
        try (InputStream stream = ResourceUtils.getAsStream(name);){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    public static String getAsString(String name) throws IOException {
        try (InputStream stream = ResourceUtils.getAsStream(name);){
            String string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }
}

