/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.webservertestbed.junit5;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.elypia.webservertestbed.ResourceUtils;
import org.elypia.webservertestbed.junit5.Resource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoaderExtension
implements TestInstancePostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ResourceLoaderExtension.class);

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        logger.debug("Processing Test Instance: {}", testInstance);
        Class<?> testClazz = testInstance.getClass();
        List fields = AnnotationSupport.findAnnotatedFields(testClazz, Resource.class);
        for (Field field : fields) {
            if (field.get(testInstance) != null) continue;
            Resource resource = field.getAnnotation(Resource.class);
            String resourcePath = resource.value();
            Class<?> fieldClazz = field.getType();
            if (fieldClazz == InputStream.class) {
                field.set(testInstance, ResourceUtils.getAsStream((String)resourcePath));
                continue;
            }
            if (fieldClazz == String.class) {
                field.set(testInstance, ResourceUtils.getAsString((String)resourcePath));
                continue;
            }
            if (fieldClazz == byte[].class) {
                field.set(testInstance, ResourceUtils.getAsBytes((String)resourcePath));
                continue;
            }
            throw new IllegalStateException(Resource.class + " can not be used for field of type " + fieldClazz + ".");
        }
    }
}

