/*
 * Decompiled with CFR 0.152.
 */
package org.elypia.webservertestbed.junit5;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.elypia.webservertestbed.Mock;
import org.elypia.webservertestbed.junit5.Response;
import org.elypia.webservertestbed.junit5.WebServer;
import org.elypia.webservertestbed.junit5.WebServerTest;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServerExtension
implements TestInstancePostProcessor,
BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final Logger logger = LoggerFactory.getLogger(WebServerExtension.class);
    private final boolean beforeEach;
    private MockWebServer mockWebServer;

    public WebServerExtension() {
        this(false);
    }

    public WebServerExtension(boolean beforeEach) {
        this.beforeEach = beforeEach;
        this.mockWebServer = new MockWebServer();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (!this.beforeEach) {
            this.mockWebServer.start();
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (!this.beforeEach) {
            this.mockWebServer.close();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Method method;
        Optional optTest;
        Optional optMethod;
        if (this.beforeEach) {
            this.mockWebServer.start();
        }
        if ((optMethod = context.getTestMethod()).isPresent() && (optTest = AnnotationSupport.findAnnotation((AnnotatedElement)(method = (Method)optMethod.get()), WebServerTest.class)).isPresent()) {
            WebServerTest test = (WebServerTest)optTest.get();
            for (String content : test.value()) {
                MockResponse mockResponse = Mock.of((String)content, (int)200, test.loader());
                this.mockWebServer.enqueue(mockResponse);
            }
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.beforeEach) {
            this.mockWebServer.close();
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Class<?> testClazz = testInstance.getClass();
        this.setMockWebServerInstance(testInstance, testClazz);
        this.setMockResponseInstances(testInstance, testClazz);
    }

    private void setMockWebServerInstance(Object testInstance, Class<?> testClazz) throws IllegalAccessException {
        List mockWebServerFields = AnnotationSupport.findPublicAnnotatedFields(testClazz, MockWebServer.class, WebServer.class);
        if (mockWebServerFields.isEmpty()) {
            return;
        }
        if (mockWebServerFields.size() > 1) {
            logger.warn("There is no reason to inject the {} more than once.", MockWebServer.class);
        }
        for (Field mockWebServerField : mockWebServerFields) {
            mockWebServerField.set(testInstance, this.mockWebServer);
        }
    }

    private void setMockResponseInstances(Object testInstance, Class<?> testClazz) throws IllegalAccessException, InstantiationException, IOException, InvocationTargetException {
        List mockResponseFields = AnnotationSupport.findPublicAnnotatedFields(testClazz, MockResponse.class, Response.class);
        for (Field field : mockResponseFields) {
            if (field.get(testInstance) != null) continue;
            Response response = field.getAnnotation(Response.class);
            MockResponse mockResponse = Mock.of((String)response.value(), (int)response.responseCode(), response.loader());
            field.set(testInstance, mockResponse);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return MockWebServer.class == parameterContext.getParameter().getType();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.mockWebServer;
    }

    public URL getRequestUrl() {
        return this.getRequestUrl("/");
    }

    public URL getRequestUrl(String path) {
        Objects.requireNonNull(path);
        return this.mockWebServer.url(path).url();
    }

    public MockWebServer getServer() {
        return this.mockWebServer;
    }
}

