/*
 * Decompiled with CFR 0.152.
 */
package org.emmalanguage.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.emmalanguage.config.ConfigReader;
import org.emmalanguage.server.GraphServlet;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.StringBuilder;

public final class HttpServer$ {
    public static final HttpServer$ MODULE$;
    private final String EXAMPLE_DIR_DEFAULT;
    private final String CODEGEN_DIR_DEFAULT;
    private Logger LOGGER;
    private Server server;
    private Option<Path> graphPath;

    static {
        new HttpServer$();
    }

    private final String EXAMPLE_DIR_DEFAULT() {
        return this.EXAMPLE_DIR_DEFAULT;
    }

    private final String CODEGEN_DIR_DEFAULT() {
        return this.CODEGEN_DIR_DEFAULT;
    }

    public Logger LOGGER() {
        return this.LOGGER;
    }

    public void LOGGER_$eq(Logger x$1) {
        this.LOGGER = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    public void main(String[] args) throws Exception {
        if (Predef$.MODULE$.refArrayOps((Object[])args).size() != 1) {
            Predef$.MODULE$.println((Object)"Missing 1st argument (graph path)");
            System.exit(1);
        }
        this.graphPath = new Some((Object)Paths.get(args[0], new String[0]));
        System.setOut(this.createLoggingProxy(System.out));
        System.setErr(this.createLoggingProxy(System.err));
        this.start();
    }

    public PrintStream createLoggingProxy(PrintStream realPrintStream) {
        return new PrintStream(realPrintStream){
            private final PrintStream realPrintStream$1;

            public void print(String string) {
                this.realPrintStream$1.print(string);
                HttpServer$.MODULE$.LOGGER().info((Object)string);
            }
            {
                this.realPrintStream$1 = realPrintStream$1;
                super(realPrintStream$1);
            }
        };
    }

    public void start() {
        File exampleDir = Paths.get(System.getProperty("emma.example.dir", this.EXAMPLE_DIR_DEFAULT()), new String[0]).normalize().toAbsolutePath().toFile();
        File codegenDir = Paths.get(System.getProperty("emma.codegen.dir", this.CODEGEN_DIR_DEFAULT()), new String[0]).normalize().toAbsolutePath().toFile();
        codegenDir.mkdirs();
        this.addFile(codegenDir);
        this.addFile(exampleDir);
        this.server_$eq(new Server(ConfigReader.getInt("port")));
        WebAppContext context = new WebAppContext();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        context.setClassLoader(cl);
        context.getInitParams().put("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        context.setContextPath("/");
        context.setResourceBase("public");
        context.setWelcomeFiles((String[])((Object[])new String[]{"index.html"}));
        context.addServlet(new ServletHolder((Servlet)new GraphServlet((Path)this.graphPath.get())), "/graph/*");
        this.server().setHandler((Handler)context);
        try {
            this.server().start();
            System.out.println(new StringBuilder().append((Object)"Started server at port: ").append((Object)ConfigReader.getString("port")).toString());
            this.server().join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addFile(File f) {
        this.addURL(f.toURI().toURL());
    }

    public void addURL(URL u) {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
            return;
        }
        catch (Throwable throwable) {
            throw new IOException("Error, could not add URL to system classloader", throwable);
        }
    }

    private HttpServer$() {
        MODULE$ = this;
        this.EXAMPLE_DIR_DEFAULT = ((Object)Paths.get(System.getProperty("user.dir"), "..", "emma-examples", "src", "main", "scala").normalize().toAbsolutePath()).toString();
        this.CODEGEN_DIR_DEFAULT = ((Object)Paths.get(System.getProperty("java.io.tmpdir"), "emma", "codegen").normalize().toAbsolutePath()).toString();
        this.LOGGER = Logger.getRootLogger();
        this.server = null;
        this.graphPath = None$.MODULE$;
    }
}

