/*
 * Copyright © 2014 TU Berlin (emma@dima.tu-berlin.de)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.emmalanguage
package api.alg

// !!! DO NOT MODIFY - SOURCE FILE GENERATED BY `tools/generate_alg_products.py` !!!

//@formatter:off

case class Alg2[A,B1,B2]
(
  alg1: Alg[A,B1],
  alg2: Alg[A,B2]
) extends Alg[A,(B1,B2)] {
  type B = (B1,B2)
  val zero: B = (
    alg1.zero,
    alg2.zero
  )
  val init: A => B = (x: A) => (
    alg1.init(x),
    alg2.init(x)
  )
  val plus: (B,B) => B = (x: B, y: B) => (
    alg1.plus(x._1, y._1),
    alg2.plus(x._2, y._2)
  )
}

//@formatter:on
