/*
 * Decompiled with CFR 0.152.
 */
package org.emmalanguage.lib.linalg;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.F2jBLAS;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BLAS$
implements Serializable {
    public static final BLAS$ MODULE$;
    private transient BLAS _f2jBLAS;
    private transient BLAS _nativeBLAS;

    static {
        new BLAS$();
    }

    private BLAS _f2jBLAS() {
        return this._f2jBLAS;
    }

    private void _f2jBLAS_$eq(BLAS x$1) {
        this._f2jBLAS = x$1;
    }

    private BLAS _nativeBLAS() {
        return this._nativeBLAS;
    }

    private void _nativeBLAS_$eq(BLAS x$1) {
        this._nativeBLAS = x$1;
    }

    private BLAS f2jBLAS() {
        if (this._f2jBLAS() == null) {
            this._f2jBLAS_$eq((BLAS)new F2jBLAS());
        }
        return this._f2jBLAS();
    }

    public void axpy(double a, Vector x, Vector y) {
        block2: {
            block5: {
                block4: {
                    Vector vector;
                    DenseVector denseVector;
                    block3: {
                        Predef$.MODULE$.require(x.size() == y.size());
                        Vector vector2 = y;
                        if (!(vector2 instanceof DenseVector)) break block2;
                        denseVector = (DenseVector)vector2;
                        vector = x;
                        if (!(vector instanceof SparseVector)) break block3;
                        SparseVector sparseVector = (SparseVector)vector;
                        this.axpy(a, sparseVector, denseVector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!(vector instanceof DenseVector)) break block5;
                    DenseVector denseVector2 = (DenseVector)vector;
                    this.axpy(a, denseVector2, denseVector);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"axpy doesn't support x type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass()})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"axpy only supports adding to a dense vector but got type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{y.getClass()})));
    }

    private void axpy(double a, DenseVector x, DenseVector y) {
        int n = x.size();
        this.f2jBLAS().daxpy(n, a, x.values(), 1, y.values(), 1);
    }

    private void axpy(double a, SparseVector x, DenseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int nnz = xIndices.length;
        if (a == 1.0) {
            for (int k = 0; k < nnz; ++k) {
                int n = xIndices[k];
                yValues[n] = yValues[n] + xValues[k];
            }
        } else {
            for (int k = 0; k < nnz; ++k) {
                int n = xIndices[k];
                yValues[n] = yValues[n] + a * xValues[k];
            }
        }
    }

    public void axpy(double a, DenseMatrix X, DenseMatrix Y) {
        Predef$.MODULE$.require(X.numRows() == Y.numRows() && X.numCols() == Y.numCols(), (Function0)new Serializable(X, Y){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix X$1;
            private final DenseMatrix Y$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Dimension mismatch: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size(X) = ", " but size(Y) = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Tuple2.mcII.sp(this.X$1.numRows(), this.X$1.numCols()), new Tuple2.mcII.sp(this.Y$1.numRows(), this.Y$1.numCols())}))).toString();
            }
            {
                this.X$1 = X$1;
                this.Y$1 = Y$1;
            }
        });
        this.f2jBLAS().daxpy(X.numRows() * X.numCols(), a, X.values(), 1, Y.values(), 1);
    }

    public double dot(Vector x, Vector y) {
        block6: {
            double d;
            block3: {
                Tuple2 tuple2;
                block5: {
                    block4: {
                        block2: {
                            Predef$.MODULE$.require(x.size() == y.size(), (Function0)new Serializable(x, y){
                                public static final long serialVersionUID = 0L;
                                private final Vector x$1;
                                private final Vector y$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"BLAS.dot(x: Vector, y:Vector) was given Vectors with non-matching sizes: x.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.x$1.size())).append((Object)", y.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.y$1.size())).toString();
                                }
                                {
                                    this.x$1 = x$1;
                                    this.y$1 = y$1;
                                }
                            });
                            tuple2 = new Tuple2((Object)x, (Object)y);
                            if (tuple2 == null) break block2;
                            Vector dx = (Vector)tuple2._1();
                            Vector dy = (Vector)tuple2._2();
                            if (!(dx instanceof DenseVector)) break block2;
                            DenseVector denseVector = (DenseVector)dx;
                            if (!(dy instanceof DenseVector)) break block2;
                            DenseVector denseVector2 = (DenseVector)dy;
                            d = this.dot(denseVector, denseVector2);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Vector sx = (Vector)tuple2._1();
                        Vector dy = (Vector)tuple2._2();
                        if (!(sx instanceof SparseVector)) break block4;
                        SparseVector sparseVector = (SparseVector)sx;
                        if (!(dy instanceof DenseVector)) break block4;
                        DenseVector denseVector = (DenseVector)dy;
                        d = this.dot(sparseVector, denseVector);
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    Vector dx = (Vector)tuple2._1();
                    Vector sy = (Vector)tuple2._2();
                    if (!(dx instanceof DenseVector)) break block5;
                    DenseVector denseVector = (DenseVector)dx;
                    if (!(sy instanceof SparseVector)) break block5;
                    SparseVector sparseVector = (SparseVector)sy;
                    d = this.dot(sparseVector, denseVector);
                    break block3;
                }
                if (tuple2 == null) break block6;
                Vector sx = (Vector)tuple2._1();
                Vector sy = (Vector)tuple2._2();
                if (!(sx instanceof SparseVector)) break block6;
                SparseVector sparseVector = (SparseVector)sx;
                if (!(sy instanceof SparseVector)) break block6;
                SparseVector sparseVector2 = (SparseVector)sy;
                d = this.dot(sparseVector, sparseVector2);
            }
            return d;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dot doesn't support (", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass(), y.getClass()})));
    }

    private double dot(DenseVector x, DenseVector y) {
        int n = x.size();
        return this.f2jBLAS().ddot(n, x.values(), 1, y.values(), 1);
    }

    private double dot(SparseVector x, DenseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int nnz = xIndices.length;
        double sum = 0.0;
        for (int k = 0; k < nnz; ++k) {
            sum += xValues[k] * yValues[xIndices[k]];
        }
        return sum;
    }

    private double dot(SparseVector x, SparseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int[] yIndices = y.indices();
        int nnzx = xIndices.length;
        int nnzy = yIndices.length;
        int ky = 0;
        double sum = 0.0;
        for (int kx = 0; kx < nnzx && ky < nnzy; ++kx) {
            int ix = xIndices[kx];
            while (ky < nnzy && yIndices[ky] < ix) {
                ++ky;
            }
            if (ky >= nnzy || yIndices[ky] != ix) continue;
            sum += xValues[kx] * yValues[ky];
            ++ky;
        }
        return sum;
    }

    public void copy(Vector x, Vector y) {
        block5: {
            Vector vector;
            block8: {
                block7: {
                    DenseVector denseVector;
                    int n;
                    block6: {
                        n = y.size();
                        Predef$.MODULE$.require(x.size() == n);
                        Vector vector2 = y;
                        if (!(vector2 instanceof DenseVector)) break block5;
                        denseVector = (DenseVector)vector2;
                        vector = x;
                        if (!(vector instanceof SparseVector)) break block6;
                        SparseVector sparseVector = (SparseVector)vector;
                        int[] sxIndices = sparseVector.indices();
                        double[] sxValues = sparseVector.values();
                        double[] dyValues = denseVector.values();
                        int nnz = sxIndices.length;
                        int i = 0;
                        for (int k = 0; k < nnz; ++k) {
                            int j = sxIndices[k];
                            while (i < j) {
                                dyValues[i] = 0.0;
                                ++i;
                            }
                            dyValues[i] = sxValues[k];
                            ++i;
                        }
                        while (i < n) {
                            dyValues[i] = 0.0;
                            ++i;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    if (!(vector instanceof DenseVector)) break block8;
                    DenseVector denseVector2 = (DenseVector)vector;
                    Array$.MODULE$.copy((Object)denseVector2.values(), 0, (Object)denseVector.values(), 0, n);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new MatchError((Object)vector);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y must be dense in copy but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{y.getClass()})));
    }

    public void scal(double a, Vector x) {
        block4: {
            block3: {
                Vector vector;
                block2: {
                    vector = x;
                    if (!(vector instanceof SparseVector)) break block2;
                    SparseVector sparseVector = (SparseVector)vector;
                    this.f2jBLAS().dscal(sparseVector.values().length, a, sparseVector.values(), 1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(vector instanceof DenseVector)) break block4;
                DenseVector denseVector = (DenseVector)vector;
                this.f2jBLAS().dscal(denseVector.values().length, a, denseVector.values(), 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scal doesn't support vector type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x.getClass()})));
    }

    private BLAS nativeBLAS() {
        if (this._nativeBLAS() == null) {
            this._nativeBLAS_$eq(BLAS.getInstance());
        }
        return this._nativeBLAS();
    }

    public void spr(double alpha, Vector v, DenseVector U) {
        this.spr(alpha, v, U.values());
    }

    public void dspmv(int n, double alpha, DenseVector A, DenseVector x, double beta, DenseVector y) {
        this.f2jBLAS().dspmv("U", n, alpha, A.values(), x.values(), 1, beta, y.values(), 1);
    }

    public void spr(double alpha, Vector v, double[] U) {
        Vector vector;
        block6: {
            block5: {
                SparseVector sparseVector;
                Option option;
                block4: {
                    DenseVector denseVector;
                    Option option2;
                    int n = v.size();
                    vector = v;
                    if (!(vector instanceof DenseVector) || (option2 = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block4;
                    double[] values = (double[])option2.get();
                    BLAS.getInstance().dspr("U", n, alpha, values, 1, U);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!(vector instanceof SparseVector) || (option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) break block6;
                int[] indices = (int[])((Tuple3)option.get())._2();
                double[] values = (double[])((Tuple3)option.get())._3();
                int nnz = indices.length;
                int colStartIdx = 0;
                int prevCol = 0;
                int col = 0;
                int i = 0;
                double av = 0.0;
                for (int j = 0; j < nnz; ++j) {
                    col = indices[j];
                    colStartIdx += (col - prevCol) * (col + prevCol + 1) / 2;
                    col = indices[j];
                    av = alpha * values[j];
                    for (i = 0; i <= j; ++i) {
                        int n = colStartIdx + indices[i];
                        U[n] = U[n] + av * values[i];
                    }
                    prevCol = col;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)vector);
    }

    public void gemm(double alpha, Matrix A, DenseMatrix B, double beta, DenseMatrix C) {
        block5: {
            block2: {
                Matrix matrix;
                block4: {
                    block3: {
                        Predef$.MODULE$.require(!C.isTransposed(), (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "The matrix C cannot be the product of a transpose() call. C.isTransposed must be false.";
                            }
                        });
                        if (alpha == 0.0 && beta == 1.0) break block2;
                        if (alpha != 0.0) break block3;
                        this.f2jBLAS().dscal(C.values().length, beta, C.values(), 1);
                        break block2;
                    }
                    matrix = A;
                    if (!(matrix instanceof SparseMatrix)) break block4;
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    this.gemm(alpha, sparseMatrix, B, beta, C);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (!(matrix instanceof DenseMatrix)) break block5;
                DenseMatrix denseMatrix = (DenseMatrix)matrix;
                this.gemm(alpha, denseMatrix, B, beta, C);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gemm doesn't support matrix type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A.getClass()})));
    }

    private void gemm(double alpha, DenseMatrix A, DenseMatrix B, double beta, DenseMatrix C) {
        String tAstr = A.isTransposed() ? "T" : "N";
        String tBstr = B.isTransposed() ? "T" : "N";
        int lda = A.isTransposed() ? A.numCols() : A.numRows();
        int ldb = B.isTransposed() ? B.numCols() : B.numRows();
        Predef$.MODULE$.require(A.numCols() == B.numRows(), (Function0)new Serializable(A, B){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix A$1;
            private final DenseMatrix B$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of A don't match the rows of B. A: ", ", B: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.A$1.numCols()), BoxesRunTime.boxToInteger((int)this.B$1.numRows())}));
            }
            {
                this.A$1 = A$1;
                this.B$1 = B$1;
            }
        });
        Predef$.MODULE$.require(A.numRows() == C.numRows(), (Function0)new Serializable(A, C){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix A$1;
            private final DenseMatrix C$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The rows of C don't match the rows of A. C: ", ", A: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.C$2.numRows()), BoxesRunTime.boxToInteger((int)this.A$1.numRows())}));
            }
            {
                this.A$1 = A$1;
                this.C$2 = C$2;
            }
        });
        Predef$.MODULE$.require(B.numCols() == C.numCols(), (Function0)new Serializable(B, C){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix B$1;
            private final DenseMatrix C$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of C don't match the columns of B. C: ", ", A: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.C$2.numCols()), BoxesRunTime.boxToInteger((int)this.B$1.numCols())}));
            }
            {
                this.B$1 = B$1;
                this.C$2 = C$2;
            }
        });
        this.nativeBLAS().dgemm(tAstr, tBstr, A.numRows(), B.numCols(), A.numCols(), alpha, A.values(), lda, B.values(), ldb, beta, C.values(), C.numRows());
    }

    private void gemm(double alpha, SparseMatrix A, DenseMatrix B, double beta, DenseMatrix C) {
        int kB;
        int mA = A.numRows();
        int nB = B.numCols();
        int kA = A.numCols();
        Predef$.MODULE$.require(kA == (kB = B.numRows()), (Function0)new Serializable(kA, kB){
            public static final long serialVersionUID = 0L;
            private final int kA$1;
            private final int kB$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of A don't match the rows of B. A: ", ", B: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kA$1), BoxesRunTime.boxToInteger((int)this.kB$1)}));
            }
            {
                this.kA$1 = kA$1;
                this.kB$1 = kB$1;
            }
        });
        Predef$.MODULE$.require(mA == C.numRows(), (Function0)new Serializable(C, mA){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix C$1;
            private final int mA$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The rows of C don't match the rows of A. C: ", ", A: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.C$1.numRows()), BoxesRunTime.boxToInteger((int)this.mA$1)}));
            }
            {
                this.C$1 = C$1;
                this.mA$1 = mA$1;
            }
        });
        Predef$.MODULE$.require(nB == C.numCols(), (Function0)new Serializable(C, nB){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix C$1;
            private final int nB$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of C don't match the columns of B. C: ", ", A: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.C$1.numCols()), BoxesRunTime.boxToInteger((int)this.nB$1)}));
            }
            {
                this.C$1 = C$1;
                this.nB$1 = nB$1;
            }
        });
        double[] Avals = A.values();
        double[] Bvals = B.values();
        double[] Cvals = C.values();
        int[] ArowIndices = A.rowIndices();
        int[] AcolPtrs = A.colPtrs();
        if (A.isTransposed()) {
            int colCounterForB;
            if (B.isTransposed()) {
                for (colCounterForB = 0; colCounterForB < nB; ++colCounterForB) {
                    int Cstart = colCounterForB * mA;
                    for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                        int indEnd = AcolPtrs[rowCounterForA + 1];
                        double sum = 0.0;
                        for (int i = AcolPtrs[rowCounterForA]; i < indEnd; ++i) {
                            sum += Avals[i] * B.apply(ArowIndices[i], colCounterForB);
                        }
                        int Cindex = Cstart + rowCounterForA;
                        Cvals[Cindex] = beta * Cvals[Cindex] + sum * alpha;
                    }
                }
            } else {
                while (colCounterForB < nB) {
                    int Cstart = colCounterForB * mA;
                    int Bstart = colCounterForB * kA;
                    for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                        int indEnd = AcolPtrs[rowCounterForA + 1];
                        double sum = 0.0;
                        for (int i = AcolPtrs[rowCounterForA]; i < indEnd; ++i) {
                            sum += Avals[i] * Bvals[Bstart + ArowIndices[i]];
                        }
                        int Cindex = Cstart + rowCounterForA;
                        Cvals[Cindex] = beta * Cvals[Cindex] + sum * alpha;
                    }
                    ++colCounterForB;
                }
            }
        } else {
            int colCounterForB;
            if (beta != 1.0) {
                this.f2jBLAS().dscal(C.values().length, beta, C.values(), 1);
            }
            if (B.isTransposed()) {
                for (colCounterForB = 0; colCounterForB < nB; ++colCounterForB) {
                    int Cstart = colCounterForB * mA;
                    for (int colCounterForA = 0; colCounterForA < kA; ++colCounterForA) {
                        int indEnd = AcolPtrs[colCounterForA + 1];
                        double Bval = B.apply(colCounterForA, colCounterForB) * alpha;
                        for (int i = AcolPtrs[colCounterForA]; i < indEnd; ++i) {
                            int n = Cstart + ArowIndices[i];
                            Cvals[n] = Cvals[n] + Avals[i] * Bval;
                        }
                    }
                }
            } else {
                while (colCounterForB < nB) {
                    int Bstart = colCounterForB * kB;
                    int Cstart = colCounterForB * mA;
                    for (int colCounterForA = 0; colCounterForA < kA; ++colCounterForA) {
                        int indEnd = AcolPtrs[colCounterForA + 1];
                        double Bval = Bvals[Bstart + colCounterForA] * alpha;
                        for (int i = AcolPtrs[colCounterForA]; i < indEnd; ++i) {
                            int n = Cstart + ArowIndices[i];
                            Cvals[n] = Cvals[n] + Avals[i] * Bval;
                        }
                    }
                    ++colCounterForB;
                }
            }
        }
    }

    public void gemv(double alpha, Matrix A, Vector x, double beta, DenseVector y) {
        block7: {
            block2: {
                Tuple2 tuple2;
                block6: {
                    block5: {
                        block4: {
                            block3: {
                                Predef$.MODULE$.require(A.numCols() == x.size(), (Function0)new Serializable(A, x){
                                    public static final long serialVersionUID = 0L;
                                    private final Matrix A$2;
                                    private final Vector x$2;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The columns of A don't match the number of elements of x. A: ", ", x: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.A$2.numCols()), BoxesRunTime.boxToInteger((int)this.x$2.size())}));
                                    }
                                    {
                                        this.A$2 = A$2;
                                        this.x$2 = x$2;
                                    }
                                });
                                Predef$.MODULE$.require(A.numRows() == y.size(), (Function0)new Serializable(A, y){
                                    public static final long serialVersionUID = 0L;
                                    private final Matrix A$2;
                                    private final DenseVector y$2;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The rows of A don't match the number of elements of y. A: ", ", y:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.A$2.numRows()), BoxesRunTime.boxToInteger((int)this.y$2.size())}));
                                    }
                                    {
                                        this.A$2 = A$2;
                                        this.y$2 = y$2;
                                    }
                                });
                                if (alpha == 0.0 && beta == 1.0) break block2;
                                if (alpha != 0.0) break block3;
                                this.scal(beta, (Vector)y);
                                break block2;
                            }
                            tuple2 = new Tuple2((Object)A, (Object)x);
                            if (tuple2 == null) break block4;
                            Matrix smA = (Matrix)tuple2._1();
                            Vector dvx = (Vector)tuple2._2();
                            if (!(smA instanceof SparseMatrix)) break block4;
                            SparseMatrix sparseMatrix = (SparseMatrix)smA;
                            if (!(dvx instanceof DenseVector)) break block4;
                            DenseVector denseVector = (DenseVector)dvx;
                            this.gemv(alpha, sparseMatrix, denseVector, beta, y);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block2;
                        }
                        if (tuple2 == null) break block5;
                        Matrix smA = (Matrix)tuple2._1();
                        Vector svx = (Vector)tuple2._2();
                        if (!(smA instanceof SparseMatrix)) break block5;
                        SparseMatrix sparseMatrix = (SparseMatrix)smA;
                        if (!(svx instanceof SparseVector)) break block5;
                        SparseVector sparseVector = (SparseVector)svx;
                        this.gemv(alpha, sparseMatrix, sparseVector, beta, y);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block2;
                    }
                    if (tuple2 == null) break block6;
                    Matrix dmA = (Matrix)tuple2._1();
                    Vector dvx = (Vector)tuple2._2();
                    if (!(dmA instanceof DenseMatrix)) break block6;
                    DenseMatrix denseMatrix = (DenseMatrix)dmA;
                    if (!(dvx instanceof DenseVector)) break block6;
                    DenseVector denseVector = (DenseVector)dvx;
                    this.gemv(alpha, denseMatrix, denseVector, beta, y);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (tuple2 == null) break block7;
                Matrix dmA = (Matrix)tuple2._1();
                Vector svx = (Vector)tuple2._2();
                if (!(dmA instanceof DenseMatrix)) break block7;
                DenseMatrix denseMatrix = (DenseMatrix)dmA;
                if (!(svx instanceof SparseVector)) break block7;
                SparseVector sparseVector = (SparseVector)svx;
                this.gemv(alpha, denseMatrix, sparseVector, beta, y);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gemv doesn't support running on matrix type "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and vector type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{A.getClass(), x.getClass()}))).toString());
    }

    private void gemv(double alpha, DenseMatrix A, DenseVector x, double beta, DenseVector y) {
        String tStrA = A.isTransposed() ? "T" : "N";
        int mA = A.isTransposed() ? A.numCols() : A.numRows();
        int nA = A.isTransposed() ? A.numRows() : A.numCols();
        this.nativeBLAS().dgemv(tStrA, mA, nA, alpha, A.values(), mA, x.values(), 1, beta, y.values(), 1);
    }

    private void gemv(double alpha, DenseMatrix A, SparseVector x, double beta, DenseVector y) {
        int mA = A.numRows();
        int nA = A.numCols();
        double[] Avals = A.values();
        int[] xIndices = x.indices();
        int xNnz = xIndices.length;
        double[] xValues = x.values();
        double[] yValues = y.values();
        if (A.isTransposed()) {
            for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                double sum = 0.0;
                for (int k = 0; k < xNnz; ++k) {
                    sum += xValues[k] * Avals[xIndices[k] + rowCounterForA * nA];
                }
                yValues[rowCounterForA] = sum * alpha + beta * yValues[rowCounterForA];
            }
        } else {
            for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                double sum = 0.0;
                for (int k = 0; k < xNnz; ++k) {
                    sum += xValues[k] * Avals[xIndices[k] * mA + rowCounterForA];
                }
                yValues[rowCounterForA] = sum * alpha + beta * yValues[rowCounterForA];
            }
        }
    }

    private void gemv(double alpha, SparseMatrix A, SparseVector x, double beta, DenseVector y) {
        int[] Acols;
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        int xNnz = xIndices.length;
        double[] yValues = y.values();
        int mA = A.numRows();
        int nA = A.numCols();
        double[] Avals = A.values();
        int[] Arows = A.isTransposed() ? A.colPtrs() : A.rowIndices();
        int[] nArray = Acols = A.isTransposed() ? A.rowIndices() : A.colPtrs();
        if (A.isTransposed()) {
            for (int rowCounter = 0; rowCounter < mA; ++rowCounter) {
                int i = Arows[rowCounter];
                int indEnd = Arows[rowCounter + 1];
                double sum = 0.0;
                int k = 0;
                while (i < indEnd && k < xNnz) {
                    if (xIndices[k] == Acols[i]) {
                        sum += Avals[i] * xValues[k];
                        ++k;
                        ++i;
                        continue;
                    }
                    if (xIndices[k] < Acols[i]) {
                        ++k;
                        continue;
                    }
                    ++i;
                }
                yValues[rowCounter] = sum * alpha + beta * yValues[rowCounter];
            }
        } else {
            if (beta != 1.0) {
                this.scal(beta, (Vector)y);
            }
            int k = 0;
            for (int colCounterForA = 0; colCounterForA < nA && k < xNnz; ++colCounterForA) {
                if (xIndices[k] != colCounterForA) continue;
                int indEnd = Acols[colCounterForA + 1];
                double xTemp = xValues[k] * alpha;
                for (int i = Acols[colCounterForA]; i < indEnd; ++i) {
                    int rowIndex = Arows[i];
                    int n = Arows[i];
                    yValues[n] = yValues[n] + Avals[i] * xTemp;
                }
                ++k;
            }
        }
    }

    private void gemv(double alpha, SparseMatrix A, DenseVector x, double beta, DenseVector y) {
        int[] Acols;
        double[] xValues = x.values();
        double[] yValues = y.values();
        int mA = A.numRows();
        int nA = A.numCols();
        double[] Avals = A.values();
        int[] Arows = A.isTransposed() ? A.colPtrs() : A.rowIndices();
        int[] nArray = Acols = A.isTransposed() ? A.rowIndices() : A.colPtrs();
        if (A.isTransposed()) {
            for (int rowCounter = 0; rowCounter < mA; ++rowCounter) {
                int indEnd = Arows[rowCounter + 1];
                double sum = 0.0;
                for (int i = Arows[rowCounter]; i < indEnd; ++i) {
                    sum += Avals[i] * xValues[Acols[i]];
                }
                yValues[rowCounter] = beta * yValues[rowCounter] + sum * alpha;
            }
        } else {
            if (beta != 1.0) {
                this.scal(beta, (Vector)y);
            }
            for (int colCounterForA = 0; colCounterForA < nA; ++colCounterForA) {
                int indEnd = Acols[colCounterForA + 1];
                double xVal = xValues[colCounterForA] * alpha;
                for (int i = Acols[colCounterForA]; i < indEnd; ++i) {
                    int rowIndex = Arows[i];
                    yValues[rowIndex] = yValues[rowIndex] + Avals[i] * xVal;
                }
            }
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BLAS$() {
        MODULE$ = this;
    }
}

