/*
 * Copyright 2011 Andreas Enblom
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.enblom.time;

/**
 * Implementation of {@link DayDateFormatter} for the EUR standard.
 * 
 * @author Andreas Enblom
 */
class DayDateFormatterEurImpl implements DayDateFormatter {

    private DayDateImpl time;

    /**
     * Creates a new formatter, that will format the given date.
     * 
     * @param date The date to format, never <code>null</code>.
     */
    DayDateFormatterEurImpl(DayDateImpl date) {
        this.time = date;
    }

    @Override
    public String formatCompactDate() {
        return
        (time.day < 10 ? "0" : "") + time.day +
        (time.month < 10 ? "0" : "") + time.month +
        time.year;
    }

    @Override
    public String formatCompactShortDate() {
        return
        (time.day < 10 ? "0" : "") + time.day +
        (time.month < 10 ? "0" : "") + time.month +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100);
    }

    @Override
    public String formatDate() {
        return
        (time.day < 10 ? "0" : "") + time.day + "." +
        (time.month < 10 ? "0" : "") + time.month + "." +
        time.year;
    }

    @Override
    public String formatShortDate() {
        return
        (time.day < 10 ? "0" : "") + time.day + "." +
        (time.month < 10 ? "0" : "") + time.month + "." +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100);
    }

}
