/*
 * Decompiled with CFR 0.152.
 */
package org.enblom.time;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.enblom.time.DayDate;
import org.enblom.time.DayDateImpl;
import org.enblom.time.Time;
import org.enblom.time.TimeFactory;
import org.enblom.time.TimeImpl;
import org.enblom.time.TimeOfDay;

class TimeFactoryImpl
implements TimeFactory {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final Time defaultTime = new TimeImpl(1970, 1, 1, 0, 0, 0, 0);

    TimeFactoryImpl() {
    }

    public Time now() {
        Calendar calendar = Calendar.getInstance();
        return TimeFactoryImpl.convert(calendar);
    }

    public Time utc() {
        Calendar calendar = Calendar.getInstance(UTC);
        return TimeFactoryImpl.convert(calendar);
    }

    public Time getDefault() {
        return defaultTime;
    }

    public Time create(DayDate date, TimeOfDay timeOfDay) {
        if (date == null) {
            throw new IllegalArgumentException("The date cannot be null");
        }
        if (timeOfDay == null) {
            throw new IllegalArgumentException("The time of day cannot be null");
        }
        return new TimeImpl((short)date.year(), (byte)date.month().toNum(), (byte)date.day(), (byte)timeOfDay.hour(), (byte)timeOfDay.minute(), (byte)timeOfDay.second(), (short)timeOfDay.millis());
    }

    public Time deserialize(String time) {
        String millis;
        String second;
        String minute;
        String hour;
        String day;
        String month;
        if (time == null || time.length() != 17) {
            throw new IllegalArgumentException("The serialization string " + time + " is not correct");
        }
        String year = time.substring(0, 4);
        Time deserialized = this.parse(year, month = time.substring(4, 6), day = time.substring(6, 8), hour = time.substring(8, 10), minute = time.substring(10, 12), second = time.substring(12, 14), millis = time.substring(14, 17));
        if (deserialized == null) {
            throw new IllegalArgumentException("The serialization string " + time + " is not correct");
        }
        return deserialized;
    }

    public Time parse(String year, String month, String day, String hour, String minute, String second) {
        try {
            return this.parse(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), 0);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Time parse(int year, int month, int day, int hour, int minute, int second) {
        return this.parse(year, month, day, hour, minute, second, 0);
    }

    public Time parse(String year, String month, String day, String hour, String minute, String second, String millis) {
        try {
            return this.parse(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(millis));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Time parse(int year, int month, int day, int hour, int minute, int second, int millis) {
        if (year < 1000 || year > 9999) {
            return null;
        }
        if (month < 1 || month > 12) {
            return null;
        }
        if (day < 1 || day > DayDateImpl.getMaxDay((short)year, (byte)month)) {
            return null;
        }
        if (hour < 0 || hour > 23) {
            return null;
        }
        if (minute < 0 || minute > 59) {
            return null;
        }
        if (second < 0 || second > 59) {
            return null;
        }
        if (millis < 0 || millis > 999) {
            return null;
        }
        return new TimeImpl((short)year, (byte)month, (byte)day, (byte)hour, (byte)minute, (byte)second, (short)millis);
    }

    public Time parse(String date, String hour, String minute, String second) {
        try {
            return this.parse(date, Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Time parse(String date, int hour, int minute, int second) {
        return this.parse(date, hour, minute, second, 0);
    }

    public Time parse(String date, String hour, String minute, String second, String millis) {
        try {
            return this.parse(date, Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(millis));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Time parse(String date, int hour, int minute, int second, int millis) {
        String day;
        String month;
        String year;
        if (date.length() == 10 && date.charAt(4) == '-' && date.charAt(7) == '-') {
            year = date.substring(0, 4);
            month = date.substring(5, 7);
            day = date.substring(8);
        } else if (date.length() == 8) {
            year = date.substring(0, 4);
            month = date.substring(4, 6);
            day = date.substring(6);
        } else {
            return null;
        }
        try {
            return this.parse(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), hour, minute, second, millis);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Time parse(String date, TimeOfDay timeOfDay) {
        return this.parse(date, timeOfDay.hour(), timeOfDay.minute(), timeOfDay.second(), timeOfDay.millis());
    }

    public Time parse(DayDate date, String hour, String minute, String second) {
        try {
            return this.parse(date, Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Time parse(DayDate date, int hour, int minute, int second) {
        return this.parse(date, hour, minute, second, 0);
    }

    public Time parse(DayDate date, String hour, String minute, String second, String millis) {
        try {
            return this.parse(date, Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(millis));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Time parse(DayDate date, int hour, int minute, int second, int millis) {
        return this.parse(date.year(), date.month().toNum(), date.day(), hour, minute, second, millis);
    }

    public Time parse(String time) {
        String millis;
        String second;
        String minute;
        String hour;
        String day;
        String month;
        String year;
        int space = time.indexOf(32);
        if (space == -1) {
            return null;
        }
        String datePart = time.substring(0, space);
        String timePart = time.substring(space + 1);
        if (datePart.length() == 10 && datePart.charAt(4) == '-' && datePart.charAt(7) == '-') {
            year = datePart.substring(0, 4);
            month = datePart.substring(5, 7);
            day = datePart.substring(8);
        } else if (datePart.length() == 8) {
            year = datePart.substring(0, 4);
            month = datePart.substring(4, 6);
            day = datePart.substring(6);
        } else {
            return null;
        }
        if (timePart.length() == 6) {
            hour = timePart.substring(0, 2);
            minute = timePart.substring(2, 4);
            second = timePart.substring(4);
            millis = "0";
        } else if (timePart.length() == 9) {
            hour = timePart.substring(0, 2);
            minute = timePart.substring(2, 4);
            second = timePart.substring(4, 6);
            millis = timePart.substring(6);
        } else if (timePart.length() == 8 && timePart.charAt(2) == ':' && timePart.charAt(5) == ':') {
            hour = timePart.substring(0, 2);
            minute = timePart.substring(3, 5);
            second = timePart.substring(6);
            millis = "0";
        } else if (timePart.length() == 12 && timePart.charAt(2) == ':' && timePart.charAt(5) == ':' && timePart.charAt(8) == '.') {
            hour = timePart.substring(0, 2);
            minute = timePart.substring(3, 5);
            second = timePart.substring(6, 8);
            millis = timePart.substring(9);
        } else {
            return null;
        }
        return this.parse(year, month, day, hour, minute, second, millis);
    }

    public Time fromJavaUtilDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return TimeFactoryImpl.convert(calendar);
    }

    public Time fromJavaUtilDate(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return TimeFactoryImpl.convert(calendar);
    }

    private static Time convert(Calendar calendar) {
        byte month;
        int yearInt = calendar.get(1);
        DayDateImpl.checkYearRange(yearInt);
        short year = (short)yearInt;
        switch (calendar.get(2)) {
            case 0: {
                month = 1;
                break;
            }
            case 1: {
                month = 2;
                break;
            }
            case 2: {
                month = 3;
                break;
            }
            case 3: {
                month = 4;
                break;
            }
            case 4: {
                month = 5;
                break;
            }
            case 5: {
                month = 6;
                break;
            }
            case 6: {
                month = 7;
                break;
            }
            case 7: {
                month = 8;
                break;
            }
            case 8: {
                month = 9;
                break;
            }
            case 9: {
                month = 10;
                break;
            }
            case 10: {
                month = 11;
                break;
            }
            case 11: {
                month = 12;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown month from java.util.Calendar: " + calendar.get(2));
            }
        }
        byte day = (byte)calendar.get(5);
        byte hour = (byte)calendar.get(11);
        byte minute = (byte)calendar.get(12);
        byte second = (byte)calendar.get(13);
        short millis = (short)calendar.get(14);
        return new TimeImpl(year, month, day, hour, minute, second, millis);
    }
}

