/*
 * Decompiled with CFR 0.152.
 */
package org.enblom.time;

import org.enblom.time.DayDate;
import org.enblom.time.DayDateImpl;
import org.enblom.time.Time;
import org.enblom.time.TimeOfDay;

public class TimeUtils {
    public static Time min(Time t1, Time t2) {
        return t2.isBefore(t1) ? t2 : t1;
    }

    public static Time max(Time t1, Time t2) {
        return t2.isAfter(t1) ? t2 : t1;
    }

    public static DayDate min(DayDate d1, DayDate d2) {
        return d1.compareTo(d2) <= 0 ? d1 : d2;
    }

    public static DayDate max(DayDate d1, DayDate d2) {
        return d1.compareTo(d2) >= 0 ? d1 : d2;
    }

    public static TimeOfDay min(TimeOfDay t1, TimeOfDay t2) {
        return t1.compareTo(t2) <= 0 ? t1 : t2;
    }

    public static TimeOfDay max(TimeOfDay t1, TimeOfDay t2) {
        return t1.compareTo(t2) >= 0 ? t1 : t2;
    }

    public static int differenceInDays(Time later, Time earlier) {
        int offsetLater = DayDateImpl.offset((short)later.year(), (byte)later.month().toNum(), (byte)later.day());
        int offsetEarlier = DayDateImpl.offset((short)earlier.year(), (byte)earlier.month().toNum(), (byte)earlier.day());
        return offsetLater - offsetEarlier;
    }

    public static int differenceInDays(DayDate later, DayDate earlier) {
        int offsetLater = DayDateImpl.offset((short)later.year(), (byte)later.month().toNum(), (byte)later.day());
        int offsetEarlier = DayDateImpl.offset((short)earlier.year(), (byte)earlier.month().toNum(), (byte)earlier.day());
        return offsetLater - offsetEarlier;
    }
}

