/*
 * Copyright 2011 Andreas Enblom
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.enblom.time;

/**
 * Implementation of {@link DayDateFormatter} for the US standard.
 * 
 * @author Andreas Enblom
 */
class DayDateFormatterUsImpl implements DayDateFormatter {

    private DayDateImpl date;

    /**
     * Creates a new formatter, that will format the given date.
     * 
     * @param date The date to format, never <code>null</code>.
     */
    DayDateFormatterUsImpl(DayDateImpl date) {
        this.date = date;
    }

    @Override
    public String formatCompactDate() {
        return
        (date.month < 10 ? "0" : "") + date.month +
        (date.day < 10 ? "0" : "") + date.day +
        date.year;
    }

    @Override
    public String formatCompactShortDate() {
        return
        (date.month < 10 ? "0" : "") + date.month +
        (date.day < 10 ? "0" : "") + date.day +
        (date.year % 100 < 10 ? "0" : "") + (date.year % 100);
    }

    @Override
    public String formatDate() {
        return
        (date.month < 10 ? "0" : "") + date.month + "/" +
        (date.day < 10 ? "0" : "") + date.day + "/" +
        date.year;
    }

    @Override
    public String formatShortDate() {
        return
        (date.month < 10 ? "0" : "") + date.month + "/" +
        (date.day < 10 ? "0" : "") + date.day + "/" +
        (date.year % 100 < 10 ? "0" : "") + (date.year % 100);
    }

}
