/*
 * Copyright 2011 Andreas Enblom
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.enblom.time;

/**
 * An exception showing that a {@link Time time}, {@link TimeOfDay time of day}
 * or {@link DayDate date} is out of range. Normally, a date should be within
 * within the range Jan 1, 1000 to Dec 31, 9999, and the time of day should be
 * within the range 00:00:00.000 to 23:59:59.999.
 * 
 * @author Andreas Enblom
 */
public class TimeOutOfRangeException extends RuntimeException {

    /**
     * Creates a new exception.
     */
    public TimeOutOfRangeException() {
    }

    /**
     * Creates a new exception with the given message and cause.
     * 
     * @param message The message.
     * @param cause The cause.
     */
    public TimeOutOfRangeException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Creates a new exception with the given message.
     * 
     * @param message The message.
     */
    public TimeOutOfRangeException(String message) {
        super(message);
    }

    /**
     * Creates a new exception with the given cause.
     * 
     * @param cause The cause.
     */
    public TimeOutOfRangeException(Throwable cause) {
        super(cause);
    }

}
