/*
 * Decompiled with CFR 0.152.
 */
package org.enblom.time;

import org.enblom.time.DayDate;
import org.enblom.time.DayDateFormatter;
import org.enblom.time.DayDateFormatterEurImpl;
import org.enblom.time.DayDateFormatterIsoImpl;
import org.enblom.time.DayDateFormatterUsImpl;
import org.enblom.time.DayOfWeek;
import org.enblom.time.Month;
import org.enblom.time.TimeOutOfRangeException;

class DayDateImpl
implements DayDate {
    static final int MAX_OFFSET = DayDateImpl.offset((short)9999, (byte)12, (byte)31);
    final short year;
    final byte month;
    final byte day;

    DayDateImpl(short year, byte month, byte day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public DayOfWeek getDayOfWeek() {
        return DayDateImpl.getDayOfWeek(this.year, this.month, this.day);
    }

    public int year() {
        return this.year;
    }

    public Month month() {
        return Month.fromNum(this.month);
    }

    public int day() {
        return this.day;
    }

    public DayDate plusYears(int offset) {
        DayDateImpl date = new DayDateImpl(DayDateImpl.addYearGetNewYear(this.year, offset), DayDateImpl.addYearGetNewMonth(this.year, this.month, offset), DayDateImpl.addYearGetNewDay(this.year, this.month, this.day, offset));
        return date;
    }

    public DayDate plusMonths(int offset) {
        DayDateImpl date = new DayDateImpl(DayDateImpl.addMonthGetNewYear(this.year, this.month, offset), DayDateImpl.addMonthGetNewMonth(this.month, offset), DayDateImpl.addMonthGetNewDay(this.year, this.month, this.day, offset));
        return date;
    }

    public DayDate plusDays(int offset) {
        return DayDateImpl.plusDays(this.year, this.month, this.day, offset);
    }

    static DayDateImpl plusDays(short year, byte month, byte day, int offset) {
        int newOffset = DayDateImpl.offset(year, month, day) + offset;
        if (newOffset < 0 || newOffset > MAX_OFFSET) {
            throw new TimeOutOfRangeException("The given offset results in a date that is out of range. Correct range is 1000-01-01--9999-12-31");
        }
        DayDateImpl newDate = DayDateImpl.fromOffset(newOffset);
        return newDate;
    }

    public boolean isLaterYearThan(DayDate date) {
        return this.year > date.year();
    }

    public boolean isSameYearAs(DayDate date) {
        return this.year == date.year();
    }

    public boolean isLaterMonthThan(DayDate date) {
        return this.year > date.year() || this.year == date.year() && this.month > date.month().toNum();
    }

    public boolean isSameMonthAs(DayDate date) {
        return this.year == date.year() && this.month() == date.month();
    }

    public int compareTo(DayDate other) {
        return this.toInt() - other.toInt();
    }

    public DayDateFormatter iso() {
        return new DayDateFormatterIsoImpl(this);
    }

    public DayDateFormatter eur() {
        return new DayDateFormatterEurImpl(this);
    }

    public DayDateFormatter us() {
        return new DayDateFormatterUsImpl(this);
    }

    public String serialize() {
        return this.iso().formatCompactDate();
    }

    public String toString() {
        return this.iso().formatDate();
    }

    public int toInt() {
        return this.year * 10000 + this.month * 100 + this.day;
    }

    public int hashCode() {
        return this.toInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DayDate)) {
            return false;
        }
        return this.toInt() == ((DayDate)obj).toInt();
    }

    static int offset(short year, byte month, byte day) {
        int offset = 0;
        offset += 365 * (year - 1000);
        offset += 1 * (year - 1001 + 4) / 4;
        offset -= 1 * (year - 1001 + 100) / 100;
        offset += 1 * (year - 1201 + 400) / 400;
        switch (month) {
            case 12: {
                offset += 30;
            }
            case 11: {
                offset += 31;
            }
            case 10: {
                offset += 30;
            }
            case 9: {
                offset += 31;
            }
            case 8: {
                offset += 31;
            }
            case 7: {
                offset += 30;
            }
            case 6: {
                offset += 31;
            }
            case 5: {
                offset += 30;
            }
            case 4: {
                offset += 31;
            }
            case 3: {
                offset += DayDateImpl.isLeapYear(year) ? 29 : 28;
            }
            case 2: {
                offset += 31;
            }
        }
        return offset += day - 1;
    }

    static DayDateImpl fromOffset(int offset) {
        byte day;
        int month;
        int remainder;
        int offset0 = offset + 364635 + 249 - 9 + 2;
        short year = (short)(offset0 * 400 / 146097 + 1);
        if (year * 365 + year / 4 - year / 100 + year / 400 <= offset0) {
            year = (short)(year + 1);
        }
        if ((remainder = offset0 - ((year - 1) * 365 + (year - 1) / 4 - (year - 1) / 100 + (year - 1) / 400)) < 31) {
            month = 1;
            day = (byte)(remainder + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28)) {
            month = 2;
            day = (byte)(remainder - 31 + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31) {
            month = 3;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28)) + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30) {
            month = 4;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31) + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31) {
            month = 5;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30) + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30) {
            month = 6;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31) + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31) {
            month = 7;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30) + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31 + 31) {
            month = 8;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31) + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31 + 31 + 30) {
            month = 9;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31 + 31) + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31) {
            month = 10;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31 + 31 + 30) + 1);
        } else if (remainder < 31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31 + 30) {
            month = 11;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31) + 1);
        } else {
            month = 12;
            day = (byte)(remainder - (31 + (DayDateImpl.isLeapYear(year) ? 29 : 28) + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31 + 30) + 1);
        }
        return new DayDateImpl(year, (byte)month, day);
    }

    static DayOfWeek getDayOfWeek(short year, byte month, byte day) {
        int offset = DayDateImpl.offset(year, month, day);
        switch (offset % 7) {
            case 0: {
                return DayOfWeek.WEDNESDAY;
            }
            case 1: {
                return DayOfWeek.THURSDAY;
            }
            case 2: {
                return DayOfWeek.FRIDAY;
            }
            case 3: {
                return DayOfWeek.SATURDAY;
            }
            case 4: {
                return DayOfWeek.SUNDAY;
            }
            case 5: {
                return DayOfWeek.MONDAY;
            }
            case 6: {
                return DayOfWeek.TUESDAY;
            }
        }
        throw new IllegalStateException("Unknown day of week: " + offset % 7 + ". This should never happen!");
    }

    static void checkYearRange(int year) throws TimeOutOfRangeException {
        if (year < 1000 || year > 9999) {
            throw new TimeOutOfRangeException("The year has to be within the range 1000-9999");
        }
    }

    static short addYearGetNewYear(short year, int offset) throws TimeOutOfRangeException {
        int newYear = year + offset;
        DayDateImpl.checkYearRange(newYear);
        return (short)newYear;
    }

    static byte addYearGetNewMonth(short year, byte month, int offset) {
        return month;
    }

    static byte addYearGetNewDay(short year, byte month, byte day, int offset) {
        short newYear = DayDateImpl.addYearGetNewYear(year, offset);
        byte maxDay = DayDateImpl.getMaxDay(newYear, month);
        return day > maxDay ? maxDay : day;
    }

    static short addMonthGetNewYear(short year, byte month, int offset) {
        int yearOffset = offset / 12;
        int newMonth = month + offset % 12;
        if (newMonth < 1) {
            --yearOffset;
        } else if (newMonth > 12) {
            ++yearOffset;
        }
        return DayDateImpl.addYearGetNewYear(year, yearOffset);
    }

    static byte addMonthGetNewMonth(byte month, int offset) {
        return (byte)(((month + offset - 1) % 12 + 12) % 12 + 1);
    }

    static byte addMonthGetNewDay(short year, byte month, byte day, int offset) {
        byte newMonth;
        short newYear = DayDateImpl.addMonthGetNewYear(year, month, offset);
        byte maxDay = DayDateImpl.getMaxDay(newYear, newMonth = DayDateImpl.addMonthGetNewMonth(month, offset));
        return day > maxDay ? maxDay : day;
    }

    static byte getMaxDay(short year, byte month) {
        switch (month) {
            case 1: {
                return 31;
            }
            case 2: {
                return (byte)(DayDateImpl.isLeapYear(year) ? 29 : 28);
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalStateException("Unknown month number: " + month);
    }

    static boolean isLeapYear(short year) {
        if (year % 400 == 0) {
            return true;
        }
        if (year % 100 == 0) {
            return false;
        }
        return year % 4 == 0;
    }
}

