/*
 * Copyright 2011 Andreas Enblom
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.enblom.time;

/**
 * A month.
 * 
 * @author Andreas Enblom
 */
public enum Month {

    /** January   */ JANUARY   (1),
    /** February  */ FEBRUARY  (2),
    /** March     */ MARCH     (3),
    /** April     */ APRIL     (4),
    /** May       */ MAY       (5),
    /** June      */ JUNE      (6),
    /** July      */ JULY      (7),
    /** August    */ AUGUST    (8),
    /** September */ SEPTEMBER (9),
    /** October   */ OCTOBER   (10),
    /** November  */ NOVEMBER  (11),
    /** December  */ DECEMBER  (12);

    /**
     * @return The number of the month in the range 1-12.
     */
    public int toNum() {
        return num;
    }

    /**
     * Returns the month with the given number in the range 1-12.
     * 
     * @param num The number of the month in the range 1-12.
     * @return The month with the given number.
     */
    public static Month fromNum(int num) {
        switch (num) {
        case 1:  return JANUARY;
        case 2:  return FEBRUARY;
        case 3:  return MARCH;
        case 4:  return APRIL;
        case 5:  return MAY;
        case 6:  return JUNE;
        case 7:  return JULY;
        case 8:  return AUGUST;
        case 9:  return SEPTEMBER;
        case 10: return OCTOBER;
        case 11: return NOVEMBER;
        case 12: return DECEMBER;
        default: throw new IllegalArgumentException("Month number out of range: " + num);
        }
    }

    private final int num;
    private Month(int num) {
        this.num = num;
    }
}
