/*
 * Copyright 2011 Andreas Enblom
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.enblom.time;

/**
 * Abstract base implementation of {@link TimeFormatter}.
 * 
 * @author Andreas Enblom
 */
abstract class TimeFormatterBaseImpl implements TimeFormatter {

    /**
     * The time to format, never <code>null</code>.
     */
    protected final TimeImpl time;

    /**
     * Creates a new formatter, that will format the given time.
     * 
     * @param time The time to format, never <code>null</code>.
     */
    TimeFormatterBaseImpl(TimeImpl time) {
        this.time = time;
    }

    @Override
    public String formatTime() {
        return
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute + ":" +
        (time.second < 10 ? "0" : "") + time.second;
    }

    @Override
    public String formatLongTime() {
        return
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute + ":" +
        (time.second < 10 ? "0" : "") + time.second + "." +
        (time.millis < 100 ? (time.millis < 10 ? "00" : "0") : "") + time.millis;
    }

    @Override
    public String formatShortTime() {
        return
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute;
    };

    @Override
    public String formatCompactTime() {
        return
        (time.hour < 10 ? "0" : "") + time.hour +
        (time.minute < 10 ? "0" : "") + time.minute +
        (time.second < 10 ? "0" : "") + time.second;
    }

    @Override
    public String formatCompactLongTime() {
        return
        (time.hour < 10 ? "0" : "") + time.hour +
        (time.minute < 10 ? "0" : "") + time.minute +
        (time.second < 10 ? "0" : "") + time.second +
        (time.millis < 100 ? (time.millis < 10 ? "00" : "0") : "") + time.millis;
    }

    @Override
    public String formatCompactShortTime() {
        return
        (time.hour < 10 ? "0" : "") + time.hour +
        (time.minute < 10 ? "0" : "") + time.minute;
    }

}
