/*
 * Copyright 2011 Andreas Enblom
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.enblom.time;

/**
 * Implementation of {@link TimeFormatter} for the US standard.
 * 
 * @author Andreas Enblom
 */
class TimeFormatterUsImpl extends TimeFormatterBaseImpl {

    /**
     * Creates a new formatter, that will format the given time.
     * 
     * @param time The time to format, never <code>null</code>.
     */
    TimeFormatterUsImpl(TimeImpl time) {
        super(time);
    }

    @Override
    public String formatDate() {
        return
        (time.month < 10 ? "0" : "") + time.month + "/" +
        (time.day < 10 ? "0" : "") + time.day + "/" +
        time.year;
    }

    @Override
    public String formatShortDate() {
        return
        (time.month < 10 ? "0" : "") + time.month + "/" +
        (time.day < 10 ? "0" : "") + time.day + "/" +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100);
    }

    @Override
    public String formatCompactDate() {
        return
        (time.month < 10 ? "0" : "") + time.month +
        (time.day < 10 ? "0" : "") + time.day +
        time.year;
    }

    @Override
    public String formatCompactShortDate() {
        return
        (time.month < 10 ? "0" : "") + time.month +
        (time.day < 10 ? "0" : "") + time.day +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100);
    }

    @Override
    public String formatDateAndTime() {
        return
        (time.month < 10 ? "0" : "") + time.month + "/" +
        (time.day < 10 ? "0" : "") + time.day + "/" +
        time.year + " " +
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute + ":" +
        (time.second < 10 ? "0" : "") + time.second;
    }

    @Override
    public String formatDateAndLongTime() {
        return
        (time.month < 10 ? "0" : "") + time.month + "/" +
        (time.day < 10 ? "0" : "") + time.day + "/" +
        time.year + " " +
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute + ":" +
        (time.second < 10 ? "0" : "") + time.second + "." +
        (time.millis < 100 ? (time.millis < 10 ? "00" : "0") : "") + time.millis;
    }

    @Override
    public String formatDateAndShortTime() {
        return
        (time.month < 10 ? "0" : "") + time.month + "/" +
        (time.day < 10 ? "0" : "") + time.day + "/" +
        time.year + " " +
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute;
    }

    @Override
    public String formatShortDateAndTime() {
        return
        (time.month < 10 ? "0" : "") + time.month + "/" +
        (time.day < 10 ? "0" : "") + time.day + "/" +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100) + " " +
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute + ":" +
        (time.second < 10 ? "0" : "") + time.second;
    }

    @Override
    public String formatShortDateAndLongTime() {
        return
        (time.month < 10 ? "0" : "") + time.month + "/" +
        (time.day < 10 ? "0" : "") + time.day + "/" +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100) + " " +
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute + ":" +
        (time.second < 10 ? "0" : "") + time.second + "." +
        (time.millis < 100 ? (time.millis < 10 ? "00" : "0") : "") + time.millis;
    }

    @Override
    public String formatShortDateAndShortTime() {
        return
        (time.month < 10 ? "0" : "") + time.month + "/" +
        (time.day < 10 ? "0" : "") + time.day + "/" +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100) + " " +
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute;
    }

    @Override
    public String formatCompactShortDateAndTime() {
        return
        (time.month < 10 ? "0" : "") + time.month +
        (time.day < 10 ? "0" : "") + time.day +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100) + " " +
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute + ":" +
        (time.second < 10 ? "0" : "") + time.second;
    }

    @Override
    public String formatCompactShortDateAndLongTime() {
        return
        (time.month < 10 ? "0" : "") + time.month +
        (time.day < 10 ? "0" : "") + time.day +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100) + " " +
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute + ":" +
        (time.second < 10 ? "0" : "") + time.second + "." +
        (time.millis < 100 ? (time.millis < 10 ? "00" : "0") : "") + time.millis;
    }

    @Override
    public String formatCompactShortDateAndShortTime() {
        return
        (time.month < 10 ? "0" : "") + time.month +
        (time.day < 10 ? "0" : "") + time.day +
        (time.year % 100 < 10 ? "0" : "") + (time.year % 100) + " " +
        (time.hour < 10 ? "0" : "") + time.hour + ":" +
        (time.minute < 10 ? "0" : "") + time.minute;
    }

}
