/*
 * Decompiled with CFR 0.152.
 */
package org.enblom.time;

import java.util.Calendar;
import java.util.TimeZone;
import org.enblom.time.DayDate;
import org.enblom.time.DayDateFactory;
import org.enblom.time.DayDateImpl;

class DayDateFactoryImpl
implements DayDateFactory {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final DayDate defaultDayDate = new DayDateImpl(1970, 1, 1);

    DayDateFactoryImpl() {
    }

    public DayDate now() {
        Calendar calendar = Calendar.getInstance();
        return DayDateFactoryImpl.convert(calendar);
    }

    public DayDate utc() {
        Calendar calendar = Calendar.getInstance(UTC);
        return DayDateFactoryImpl.convert(calendar);
    }

    public DayDate getDefault() {
        return defaultDayDate;
    }

    public DayDate deserialize(String date) throws IllegalArgumentException {
        String day;
        String month;
        if (date == null || date.length() != 8) {
            throw new IllegalArgumentException("The serialization string " + date + " is not correct");
        }
        String year = date.substring(0, 4);
        DayDate deserialized = this.parse(year, month = date.substring(4, 6), day = date.substring(6, 8));
        if (deserialized == null) {
            throw new IllegalArgumentException("The serialization string " + date + " is not correct");
        }
        return deserialized;
    }

    public DayDate parse(String year, String month, String day) {
        try {
            return this.parse(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public DayDate parse(int year, int month, int day) {
        if (year < 1000 || year > 9999) {
            return null;
        }
        if (month < 1 || month > 12) {
            return null;
        }
        if (day < 1 || day > DayDateImpl.getMaxDay((short)year, (byte)month)) {
            return null;
        }
        return new DayDateImpl((short)year, (byte)month, (byte)day);
    }

    public DayDate parse(String date) {
        String day;
        String month;
        String year;
        if (date.length() == 10 && date.charAt(4) == '-' && date.charAt(7) == '-') {
            year = date.substring(0, 4);
            month = date.substring(5, 7);
            day = date.substring(8);
        } else if (date.length() == 8) {
            year = date.substring(0, 4);
            month = date.substring(4, 6);
            day = date.substring(6);
        } else {
            return null;
        }
        return this.parse(year, month, day);
    }

    public DayDate fromInt(int date) throws IllegalArgumentException {
        return this.deserialize(Integer.toString(date));
    }

    private static DayDate convert(Calendar calendar) {
        byte month;
        int yearInt = calendar.get(1);
        DayDateImpl.checkYearRange(yearInt);
        short year = (short)yearInt;
        switch (calendar.get(2)) {
            case 0: {
                month = 1;
                break;
            }
            case 1: {
                month = 2;
                break;
            }
            case 2: {
                month = 3;
                break;
            }
            case 3: {
                month = 4;
                break;
            }
            case 4: {
                month = 5;
                break;
            }
            case 5: {
                month = 6;
                break;
            }
            case 6: {
                month = 7;
                break;
            }
            case 7: {
                month = 8;
                break;
            }
            case 8: {
                month = 9;
                break;
            }
            case 9: {
                month = 10;
                break;
            }
            case 10: {
                month = 11;
                break;
            }
            case 11: {
                month = 12;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown month from java.util.Calendar: " + calendar.get(2));
            }
        }
        byte day = (byte)calendar.get(5);
        return new DayDateImpl(year, month, day);
    }
}

