/*
 * Decompiled with CFR 0.152.
 */
package org.enblom.time;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.enblom.time.DayDate;
import org.enblom.time.DayOfWeek;
import org.enblom.time.Month;
import org.enblom.time.TimeFactory;
import org.enblom.time.TimeFactoryImpl;
import org.enblom.time.TimeFormatter;
import org.enblom.time.TimeOfDay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Time
extends Comparable<Time>,
Serializable {
    public static final TimeFactory factory = new TimeFactoryImpl();

    public DayDate getDate();

    public TimeOfDay getTimeOfDay();

    public int year();

    public Month month();

    public int day();

    public int hour();

    public int minute();

    public int second();

    public int millis();

    public DayOfWeek getDayOfWeek();

    public Time plusYears(int var1);

    public Time plusMonths(int var1);

    public Time plusDays(int var1);

    public Time plusHours(int var1);

    public Time plusMinutes(long var1);

    public Time plusSeconds(long var1);

    public Time plusMillis(long var1);

    public boolean isAfter(Time var1);

    public boolean isAfter(TimeOfDay var1);

    public boolean isAfter(int var1, int var2);

    public boolean isAfter(int var1, int var2, int var3);

    public boolean isBefore(Time var1);

    public boolean isBefore(TimeOfDay var1);

    public boolean isBefore(int var1, int var2);

    public boolean isBefore(int var1, int var2, int var3);

    public boolean isLaterYearThan(Time var1);

    public boolean isSameYearAs(Time var1);

    public boolean isLaterMonthThan(Time var1);

    public boolean isSameMonthAs(Time var1);

    public boolean isLaterDayThan(Time var1);

    public boolean isSameDayAs(Time var1);

    public boolean isLaterHourThan(Time var1);

    public boolean isSameHourAs(Time var1);

    public boolean isLaterMinuteThan(Time var1);

    public boolean isSameMinuteAs(Time var1);

    public boolean isLaterSecondThan(Time var1);

    public boolean isSameSecondAs(Time var1);

    public boolean equals(Object var1);

    public int hashCode();

    public TimeFormatter iso();

    public TimeFormatter eur();

    public TimeFormatter us();

    public String serialize();

    public Date toJavaUtilDate();

    public Date toJavaUtilDate(TimeZone var1);

    public String toString();

    public long toLong();
}

