/*
 * Decompiled with CFR 0.152.
 */
package org.enblom.time;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.enblom.time.DayDate;
import org.enblom.time.DayDateImpl;
import org.enblom.time.DayOfWeek;
import org.enblom.time.Month;
import org.enblom.time.Time;
import org.enblom.time.TimeFormatter;
import org.enblom.time.TimeFormatterEurImpl;
import org.enblom.time.TimeFormatterIsoImpl;
import org.enblom.time.TimeFormatterUsImpl;
import org.enblom.time.TimeOfDay;
import org.enblom.time.TimeOfDayImpl;

class TimeImpl
implements Time {
    final short year;
    final byte month;
    final byte day;
    final byte hour;
    final byte minute;
    final byte second;
    final short millis;

    TimeImpl(short year, byte month, byte day, byte hour, byte minute, byte second, short millis) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millis = millis;
    }

    public DayDate getDate() {
        return new DayDateImpl(this.year, this.month, this.day);
    }

    public TimeOfDay getTimeOfDay() {
        return new TimeOfDayImpl(this.hour, this.minute, this.second, this.millis);
    }

    public int year() {
        return this.year;
    }

    public Month month() {
        return Month.fromNum(this.month);
    }

    public int day() {
        return this.day;
    }

    public int hour() {
        return this.hour;
    }

    public int minute() {
        return this.minute;
    }

    public int second() {
        return this.second;
    }

    public int millis() {
        return this.millis;
    }

    public DayOfWeek getDayOfWeek() {
        return DayDateImpl.getDayOfWeek(this.year, this.month, this.day);
    }

    public Time plusYears(int offset) {
        return new TimeImpl(DayDateImpl.addYearGetNewYear(this.year, offset), DayDateImpl.addYearGetNewMonth(this.year, this.month, offset), DayDateImpl.addYearGetNewDay(this.year, this.month, this.day, offset), this.hour, this.minute, this.second, this.millis);
    }

    public Time plusMonths(int offset) {
        return new TimeImpl(DayDateImpl.addMonthGetNewYear(this.year, this.month, offset), DayDateImpl.addMonthGetNewMonth(this.month, offset), DayDateImpl.addMonthGetNewDay(this.year, this.month, this.day, offset), this.hour, this.minute, this.second, this.millis);
    }

    public Time plusDays(int offset) {
        DayDateImpl newDate = DayDateImpl.plusDays(this.year, this.month, this.day, offset);
        return new TimeImpl(newDate.year, newDate.month, newDate.day, this.hour, this.minute, this.second, this.millis);
    }

    public Time plusHours(int offset) {
        byte newHour = TimeImpl.addHoursGetNewHour(this.hour, offset);
        int dateOffset = TimeImpl.addHoursGetDayOffset(this.hour, offset);
        DayDateImpl newDate = DayDateImpl.plusDays(this.year, this.month, this.day, dateOffset);
        return new TimeImpl(newDate.year, newDate.month, newDate.day, newHour, this.minute, this.second, this.millis);
    }

    public Time plusMinutes(long offset) {
        byte newMinute = TimeImpl.addMinutesGetNewMinute(this.minute, offset);
        int hourOffset = TimeImpl.addMinutesGetHourOffset(this.minute, offset);
        byte newHour = TimeImpl.addHoursGetNewHour(this.hour, hourOffset);
        int dateOffset = TimeImpl.addHoursGetDayOffset(this.hour, hourOffset);
        DayDateImpl newDate = DayDateImpl.plusDays(this.year, this.month, this.day, dateOffset);
        return new TimeImpl(newDate.year, newDate.month, newDate.day, newHour, newMinute, this.second, this.millis);
    }

    public Time plusSeconds(long offset) {
        byte newSecond = TimeImpl.addSecondsGetNewSecond(this.second, offset);
        long minuteOffset = TimeImpl.addSecondsGetMinuteOffset(this.second, offset);
        byte newMinute = TimeImpl.addMinutesGetNewMinute(this.minute, minuteOffset);
        int hourOffset = TimeImpl.addMinutesGetHourOffset(this.minute, minuteOffset);
        byte newHour = TimeImpl.addHoursGetNewHour(this.hour, hourOffset);
        int dateOffset = TimeImpl.addHoursGetDayOffset(this.hour, hourOffset);
        DayDateImpl newDate = DayDateImpl.plusDays(this.year, this.month, this.day, dateOffset);
        return new TimeImpl(newDate.year, newDate.month, newDate.day, newHour, newMinute, newSecond, this.millis);
    }

    public Time plusMillis(long offset) {
        short newMillis = TimeImpl.addMillisGetNewMillis(this.millis, offset);
        long secondOffset = TimeImpl.addMillisGetSecondOffset(this.millis, offset);
        byte newSecond = TimeImpl.addSecondsGetNewSecond(this.second, secondOffset);
        long minuteOffset = TimeImpl.addSecondsGetMinuteOffset(this.second, secondOffset);
        byte newMinute = TimeImpl.addMinutesGetNewMinute(this.minute, minuteOffset);
        int hourOffset = TimeImpl.addMinutesGetHourOffset(this.minute, minuteOffset);
        byte newHour = TimeImpl.addHoursGetNewHour(this.hour, hourOffset);
        int dateOffset = TimeImpl.addHoursGetDayOffset(this.hour, hourOffset);
        DayDateImpl newDate = DayDateImpl.plusDays(this.year, this.month, this.day, dateOffset);
        return new TimeImpl(newDate.year, newDate.month, newDate.day, newHour, newMinute, newSecond, newMillis);
    }

    public boolean isAfter(Time time) {
        if (time == null) {
            throw new IllegalArgumentException("The time cannot be null");
        }
        return this.compareTo(time) >= 0;
    }

    public boolean isAfter(TimeOfDay time) {
        if (time == null) {
            throw new IllegalArgumentException("The time cannot be null");
        }
        return this.getTimeOfDay().compareTo(time) >= 0;
    }

    public boolean isAfter(int hours, int minutes) {
        if (this.hour > hours) {
            return true;
        }
        return this.hour == hours && this.minute >= minutes;
    }

    public boolean isAfter(int hours, int minutes, int seconds) {
        if (this.hour > hours) {
            return true;
        }
        if (this.hour == hours && this.minute > minutes) {
            return true;
        }
        return this.hour == hours && this.minute == minutes && this.second >= seconds;
    }

    public boolean isBefore(Time time) {
        if (time == null) {
            throw new IllegalArgumentException("The time cannot be null");
        }
        return this.compareTo(time) < 0;
    }

    public boolean isBefore(TimeOfDay time) {
        if (time == null) {
            throw new IllegalArgumentException("The time cannot be null");
        }
        return this.getTimeOfDay().compareTo(time) < 0;
    }

    public boolean isBefore(int hours, int minutes) {
        if (this.hour < hours) {
            return true;
        }
        return this.hour == hours && this.minute < minutes;
    }

    public boolean isBefore(int hours, int minutes, int seconds) {
        if (this.hour < hours) {
            return true;
        }
        if (this.hour == hours && this.minute < minutes) {
            return true;
        }
        return this.hour == hours && this.minute == minutes && this.second < seconds;
    }

    public boolean isLaterYearThan(Time time) {
        return this.year > time.year();
    }

    public boolean isSameYearAs(Time time) {
        return this.year == time.year();
    }

    public boolean isLaterMonthThan(Time time) {
        return this.year > time.year() || this.year == time.year() && this.month > time.month().toNum();
    }

    public boolean isSameMonthAs(Time time) {
        return this.year == time.year() && this.month == time.month().toNum();
    }

    public boolean isLaterDayThan(Time time) {
        return this.year > time.year() || this.year == time.year() && this.month > time.month().toNum() || this.year == time.year() && this.month == time.month().toNum() && this.day > time.day();
    }

    public boolean isSameDayAs(Time time) {
        return this.year == time.year() && this.month == time.month().toNum() && this.day == time.day();
    }

    public boolean isLaterHourThan(Time time) {
        return this.year > time.year() || this.year == time.year() && this.month > time.month().toNum() || this.year == time.year() && this.month == time.month().toNum() && this.day > time.day() || this.year == time.year() && this.month == time.month().toNum() && this.day == time.day() && this.hour > time.hour();
    }

    public boolean isSameHourAs(Time time) {
        return this.year == time.year() && this.month == time.month().toNum() && this.day == time.day() && this.hour == time.hour();
    }

    public boolean isLaterMinuteThan(Time time) {
        return this.year > time.year() || this.year == time.year() && this.month > time.month().toNum() || this.year == time.year() && this.month == time.month().toNum() && this.day > time.day() || this.year == time.year() && this.month == time.month().toNum() && this.day == time.day() && this.hour > time.hour() || this.year == time.year() && this.month == time.month().toNum() && this.day == time.day() && this.hour == time.hour() && this.minute > time.minute();
    }

    public boolean isSameMinuteAs(Time time) {
        return this.year == time.year() && this.month == time.month().toNum() && this.day == time.day() && this.hour == time.hour() && this.minute == time.minute();
    }

    public boolean isLaterSecondThan(Time time) {
        return this.year > time.year() || this.year == time.year() && this.month > time.month().toNum() || this.year == time.year() && this.month == time.month().toNum() && this.day > time.day() || this.year == time.year() && this.month == time.month().toNum() && this.day == time.day() && this.hour > time.hour() || this.year == time.year() && this.month == time.month().toNum() && this.day == time.day() && this.hour == time.hour() && this.minute > time.minute() || this.year == time.year() && this.month == time.month().toNum() && this.day == time.day() && this.hour == time.hour() && this.minute == time.minute() && this.second > time.second();
    }

    public boolean isSameSecondAs(Time time) {
        return this.year == time.year() && this.month == time.month().toNum() && this.day == time.day() && this.hour == time.hour() && this.minute == time.minute() && this.second == time.second();
    }

    public int compareTo(Time other) {
        long otherVal;
        long thisVal = this.toLong();
        return thisVal < (otherVal = other.toLong()) ? -1 : (thisVal == otherVal ? 0 : 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Time)) {
            return false;
        }
        return this.toLong() == ((Time)obj).toLong();
    }

    public int hashCode() {
        return Long.valueOf(this.toLong()).hashCode();
    }

    public TimeFormatter iso() {
        return new TimeFormatterIsoImpl(this);
    }

    public TimeFormatter eur() {
        return new TimeFormatterEurImpl(this);
    }

    public TimeFormatter us() {
        return new TimeFormatterUsImpl(this);
    }

    public String serialize() {
        return this.year + (this.month < 10 ? "0" : "") + this.month + (this.day < 10 ? "0" : "") + this.day + (this.hour < 10 ? "0" : "") + this.hour + (this.minute < 10 ? "0" : "") + this.minute + (this.second < 10 ? "0" : "") + this.second + (this.millis < 100 ? (this.millis < 10 ? "00" : "0") : "") + this.millis;
    }

    public String toString() {
        return this.iso().formatDateAndLongTime();
    }

    public long toLong() {
        return (long)this.year * 10000000000000L + (long)this.month * 100000000000L + (long)this.day * 1000000000L + (long)this.hour * 10000000L + (long)this.minute * 100000L + (long)this.second * 1000L + (long)this.millis * 1L;
    }

    public Date toJavaUtilDate() {
        return this.toJavaUtilDate(TimeZone.getDefault());
    }

    public Date toJavaUtilDate(TimeZone timeZone) {
        int month;
        switch (this.month()) {
            case JANUARY: {
                month = 0;
                break;
            }
            case FEBRUARY: {
                month = 1;
                break;
            }
            case MARCH: {
                month = 2;
                break;
            }
            case APRIL: {
                month = 3;
                break;
            }
            case MAY: {
                month = 4;
                break;
            }
            case JUNE: {
                month = 5;
                break;
            }
            case JULY: {
                month = 6;
                break;
            }
            case AUGUST: {
                month = 7;
                break;
            }
            case SEPTEMBER: {
                month = 8;
                break;
            }
            case OCTOBER: {
                month = 9;
                break;
            }
            case NOVEMBER: {
                month = 10;
                break;
            }
            case DECEMBER: {
                month = 11;
                break;
            }
            default: {
                throw new IllegalStateException("Unknwon month: " + (Object)((Object)this.month()));
            }
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(1, this.year);
        calendar.set(2, month);
        calendar.set(5, this.day);
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.set(14, this.millis);
        return calendar.getTime();
    }

    static int addHoursGetDayOffset(byte hour, int offset) {
        int dayOffset = offset / 24;
        int newHour = hour + offset % 24;
        if (newHour < 0) {
            --dayOffset;
        } else if (newHour > 23) {
            ++dayOffset;
        }
        return dayOffset;
    }

    static byte addHoursGetNewHour(byte hour, int offset) {
        return (byte)(((hour + offset) % 24 + 24) % 24);
    }

    static int addMinutesGetHourOffset(byte minute, long offset) {
        long hourOffset = offset / 60L;
        int newMinute = (int)((long)minute + offset % 60L);
        if (newMinute < 0) {
            --hourOffset;
        } else if (newMinute > 59) {
            ++hourOffset;
        }
        return (int)hourOffset;
    }

    static byte addMinutesGetNewMinute(byte minute, long offset) {
        return (byte)((((long)minute + offset) % 60L + 60L) % 60L);
    }

    static long addSecondsGetMinuteOffset(byte second, long offset) {
        long minuteOffset = offset / 60L;
        int newSecond = (int)((long)second + offset % 60L);
        if (newSecond < 0) {
            --minuteOffset;
        } else if (newSecond > 59) {
            ++minuteOffset;
        }
        return minuteOffset;
    }

    static byte addSecondsGetNewSecond(byte second, long offset) {
        return (byte)((((long)second + offset) % 60L + 60L) % 60L);
    }

    static long addMillisGetSecondOffset(short millis, long offset) {
        long secondOffset = offset / 1000L;
        int newMillis = (int)((long)millis + offset % 1000L);
        if (newMillis < 0) {
            --secondOffset;
        } else if (newMillis > 999) {
            ++secondOffset;
        }
        return secondOffset;
    }

    static short addMillisGetNewMillis(short millis, long offset) {
        return (short)((((long)millis + offset) % 1000L + 1000L) % 1000L);
    }
}

