/*
 * Decompiled with CFR 0.152.
 */
package org.enblom.time;

import java.util.Calendar;
import java.util.TimeZone;
import org.enblom.time.TimeOfDay;
import org.enblom.time.TimeOfDayFactory;
import org.enblom.time.TimeOfDayImpl;

class TimeOfDayFactoryImpl
implements TimeOfDayFactory {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final TimeOfDay defaultTimeOfDay = new TimeOfDayImpl(0, 0, 0, 0);

    TimeOfDayFactoryImpl() {
    }

    public TimeOfDay now() {
        Calendar calendar = Calendar.getInstance();
        return TimeOfDayFactoryImpl.convert(calendar);
    }

    public TimeOfDay utc() {
        Calendar calendar = Calendar.getInstance(UTC);
        return TimeOfDayFactoryImpl.convert(calendar);
    }

    public TimeOfDay getDefault() {
        return defaultTimeOfDay;
    }

    public TimeOfDay deserialize(String time) throws IllegalArgumentException {
        String millis;
        String second;
        String minute;
        if (time == null || time.length() != 9) {
            throw new IllegalArgumentException("The serialization string " + time + " is not correct");
        }
        String hour = time.substring(0, 2);
        TimeOfDay deserialized = this.parse(hour, minute = time.substring(2, 4), second = time.substring(4, 6), millis = time.substring(6, 9));
        if (deserialized == null) {
            throw new IllegalArgumentException("The serialization string " + time + " is not correct");
        }
        return deserialized;
    }

    public TimeOfDay parse(String hour, String minute, String second) {
        try {
            return this.parse(Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public TimeOfDay parse(int hour, int minute, int second) {
        return this.parse(hour, minute, second, 0);
    }

    public TimeOfDay parse(String hour, String minute, String second, String millis) {
        try {
            return this.parse(Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second), Integer.parseInt(millis));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public TimeOfDay parse(int hour, int minute, int second, int millis) {
        if (hour < 0 || hour > 23) {
            return null;
        }
        if (minute < 0 || minute > 59) {
            return null;
        }
        if (second < 0 || second > 59) {
            return null;
        }
        if (millis < 0 || millis > 999) {
            return null;
        }
        return new TimeOfDayImpl((byte)hour, (byte)minute, (byte)second, (short)millis);
    }

    public TimeOfDay parse(String timeOfDay) {
        String millis;
        String second;
        String minute;
        String hour;
        if (timeOfDay.length() == 6) {
            hour = timeOfDay.substring(0, 2);
            minute = timeOfDay.substring(2, 4);
            second = timeOfDay.substring(4);
            millis = "0";
        } else if (timeOfDay.length() == 9) {
            hour = timeOfDay.substring(0, 2);
            minute = timeOfDay.substring(2, 4);
            second = timeOfDay.substring(4, 6);
            millis = timeOfDay.substring(6);
        } else if (timeOfDay.length() == 8 && timeOfDay.charAt(2) == ':' && timeOfDay.charAt(5) == ':') {
            hour = timeOfDay.substring(0, 2);
            minute = timeOfDay.substring(3, 5);
            second = timeOfDay.substring(6);
            millis = "0";
        } else if (timeOfDay.length() == 12 && timeOfDay.charAt(2) == ':' && timeOfDay.charAt(5) == ':' && timeOfDay.charAt(8) == '.') {
            hour = timeOfDay.substring(0, 2);
            minute = timeOfDay.substring(3, 5);
            second = timeOfDay.substring(6, 8);
            millis = timeOfDay.substring(9);
        } else {
            return null;
        }
        return this.parse(hour, minute, second, millis);
    }

    public TimeOfDay fromInt(int time) throws IllegalArgumentException {
        return this.deserialize(Integer.toString(time));
    }

    private static TimeOfDay convert(Calendar calendar) {
        byte hour = (byte)calendar.get(11);
        byte minute = (byte)calendar.get(12);
        byte second = (byte)calendar.get(13);
        short millis = (short)calendar.get(14);
        return new TimeOfDayImpl(hour, minute, second, millis);
    }
}

