/*
 * Decompiled with CFR 0.152.
 */
package org.enblom.time;

import org.enblom.time.TimeImpl;
import org.enblom.time.TimeOfDay;
import org.enblom.time.TimeOfDayFormatter;
import org.enblom.time.TimeOfDayFormatterImpl;
import org.enblom.time.TimeOutOfRangeException;

class TimeOfDayImpl
implements TimeOfDay {
    final byte hour;
    final byte minute;
    final byte second;
    final short millis;

    TimeOfDayImpl(byte hour, byte minute, byte second, short millis) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millis = millis;
    }

    public int hour() {
        return this.hour;
    }

    public int minute() {
        return this.minute;
    }

    public int second() {
        return this.second;
    }

    public int millis() {
        return this.millis;
    }

    public TimeOfDay plusHours(int offset) {
        return new TimeOfDayImpl(TimeOfDayImpl.addHoursGetNewHour(this.hour, offset), this.minute, this.second, this.millis);
    }

    public TimeOfDay plusMinutes(int offset) {
        return new TimeOfDayImpl(TimeOfDayImpl.addMinutesGetNewHour(this.hour, this.minute, offset), TimeImpl.addMinutesGetNewMinute(this.minute, offset), this.second, this.millis);
    }

    public TimeOfDay plusSeconds(int offset) {
        return new TimeOfDayImpl(TimeOfDayImpl.addSecondsGetNewHour(this.hour, this.minute, this.second, offset), TimeOfDayImpl.addSecondsGetNewMinute(this.minute, this.second, offset), TimeImpl.addSecondsGetNewSecond(this.second, offset), this.millis);
    }

    public TimeOfDay plusMillis(int offset) {
        return new TimeOfDayImpl(TimeOfDayImpl.addMillisGetNewHour(this.hour, this.minute, this.second, this.millis, offset), TimeOfDayImpl.addMillisGetNewMinute(this.minute, this.second, this.millis, offset), TimeOfDayImpl.addMillisGetNewSecond(this.second, this.millis, offset), TimeImpl.addMillisGetNewMillis(this.millis, offset));
    }

    public boolean isAfter(int hours, int minutes) {
        if (this.hour > hours) {
            return true;
        }
        return this.hour == hours && this.minute >= minutes;
    }

    public boolean isAfter(int hours, int minutes, int seconds) {
        if (this.hour > hours) {
            return true;
        }
        if (this.hour == hours && this.minute > minutes) {
            return true;
        }
        return this.hour == hours && this.minute == minutes && this.second >= seconds;
    }

    public boolean isBefore(int hours, int minutes) {
        if (this.hour < hours) {
            return true;
        }
        return this.hour == hours && this.minute < minutes;
    }

    public boolean isBefore(int hours, int minutes, int seconds) {
        if (this.hour < hours) {
            return true;
        }
        if (this.hour == hours && this.minute < minutes) {
            return true;
        }
        return this.hour == hours && this.minute == minutes && this.second < seconds;
    }

    public boolean isLaterHourThan(TimeOfDay time) {
        return this.hour > time.hour();
    }

    public boolean isSameHourAs(TimeOfDay time) {
        return this.hour == time.hour();
    }

    public boolean isLaterMinuteThan(TimeOfDay time) {
        return this.hour > time.hour() || this.hour == time.hour() && this.minute > time.minute();
    }

    public boolean isSameMinuteAs(TimeOfDay time) {
        return this.hour == time.hour() && this.minute == time.minute();
    }

    public boolean isLaterSecondThan(TimeOfDay time) {
        return this.hour > time.hour() || this.hour == time.hour() && this.minute > time.minute() || this.hour == time.hour() && this.minute == time.minute() && this.second > time.second();
    }

    public boolean isSameSecondAs(TimeOfDay time) {
        return this.hour == time.hour() && this.minute == time.minute() && this.second == time.second();
    }

    public int compareTo(TimeOfDay other) {
        return this.toInt() - other.toInt();
    }

    public TimeOfDayFormatter iso() {
        return new TimeOfDayFormatterImpl(this);
    }

    public TimeOfDayFormatter eur() {
        return new TimeOfDayFormatterImpl(this);
    }

    public TimeOfDayFormatter us() {
        return new TimeOfDayFormatterImpl(this);
    }

    public String serialize() {
        return this.iso().formatCompactLongTime();
    }

    public String toString() {
        return this.iso().formatLongTime();
    }

    public int toInt() {
        return this.hour * 10000000 + this.minute * 100000 + this.second * 1000 + this.millis;
    }

    public int hashCode() {
        return this.toInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeOfDay)) {
            return false;
        }
        return this.toInt() == ((TimeOfDay)obj).toInt();
    }

    private static void checkHourRange(int hour) {
        if (hour < 0 || hour > 23) {
            throw new TimeOutOfRangeException("The hour has to be within the range 0 - 23");
        }
    }

    private static byte addHoursGetNewHour(byte hour, int offset) {
        int newHour = hour + offset;
        TimeOfDayImpl.checkHourRange(newHour);
        return (byte)newHour;
    }

    private static byte addMinutesGetNewHour(byte hour, byte minute, long offset) {
        int hourOffset = TimeImpl.addMinutesGetHourOffset(minute, offset);
        return TimeOfDayImpl.addHoursGetNewHour(hour, hourOffset);
    }

    private static byte addSecondsGetNewHour(byte hour, byte minute, byte second, long offset) {
        long minuteOffset = TimeImpl.addSecondsGetMinuteOffset(second, offset);
        return TimeOfDayImpl.addMinutesGetNewHour(hour, minute, minuteOffset);
    }

    private static byte addSecondsGetNewMinute(byte minute, byte second, long offset) {
        long minuteOffset = TimeImpl.addSecondsGetMinuteOffset(second, offset);
        return TimeImpl.addMinutesGetNewMinute(minute, minuteOffset);
    }

    private static byte addMillisGetNewHour(byte hour, byte minute, byte second, short millis, long offset) {
        long secondOffset = TimeImpl.addMillisGetSecondOffset(millis, offset);
        return TimeOfDayImpl.addSecondsGetNewHour(hour, minute, second, secondOffset);
    }

    private static byte addMillisGetNewMinute(byte minute, byte second, short millis, long offset) {
        long secondOffset = TimeImpl.addMillisGetSecondOffset(millis, offset);
        return TimeOfDayImpl.addSecondsGetNewMinute(minute, second, secondOffset);
    }

    private static byte addMillisGetNewSecond(byte second, short millis, long offset) {
        long secondOffset = TimeImpl.addMillisGetSecondOffset(millis, offset);
        return TimeImpl.addSecondsGetNewSecond(second, secondOffset);
    }
}

