/*
 * Decompiled with CFR 0.152.
 */
package org.encalmo.data;

import org.encalmo.data.GenericGraph;
import org.encalmo.data.Graph$;
import org.encalmo.data.MapGraph;
import org.encalmo.data.MutableMapGraph;
import org.encalmo.data.Traversable;
import org.encalmo.data.Weighted;
import scala.Function1;
import scala.Function2;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashSet;
import scala.io.Source;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;

public interface Graph<N> {
    public static <N> MutableMapGraph<N> apply() {
        return Graph$.MODULE$.apply();
    }

    public static <N> MapGraph<N> apply(scala.collection.immutable.Map<N, Traversable<N>> map) {
        return Graph$.MODULE$.apply(map);
    }

    public static <N> MapGraph<N> apply(Seq<Tuple2<N, Traversable<N>>> seq) {
        return Graph$.MODULE$.apply(seq);
    }

    public static <N, V> Graph<N> apply(Seq<Tuple2<N, Iterable<Tuple2<N, V>>>> seq, Numeric<V> numeric) {
        return Graph$.MODULE$.apply(seq, numeric);
    }

    public static <N> void bfs(Graph<N> graph, Function1<N, BoxedUnit> function1) {
        Graph$.MODULE$.bfs(graph, function1);
    }

    public static <N> void bfs(Graph<N> graph, N n, Function1<N, BoxedUnit> function1, HashSet<N> hashSet) {
        Graph$.MODULE$.bfs(graph, n, function1, hashSet);
    }

    public static <N> void dfs(Graph<N> graph, DfsVisitor<N> dfsVisitor, Traversable<N> traversable) {
        Graph$.MODULE$.dfs(graph, dfsVisitor, traversable);
    }

    public static <N> void dfs(Graph<N> graph, N n, DfsVisitor<N> dfsVisitor, HashSet<N> hashSet) {
        Graph$.MODULE$.dfs(graph, n, dfsVisitor, hashSet);
    }

    public static <N> void dfsi(Graph<N> graph, N n, DfsVisitor<N> dfsVisitor, HashSet<N> hashSet) {
        Graph$.MODULE$.dfsi(graph, n, dfsVisitor, hashSet);
    }

    public static <N> Vector<N> findCycles(Graph<N> graph) {
        return Graph$.MODULE$.findCycles(graph);
    }

    public static <N> Vector<N> findCycles(Graph<N> graph, N n, scala.collection.mutable.Map<N, Object> map) {
        return Graph$.MODULE$.findCycles(graph, n, map);
    }

    public static <N, V> Tuple2<V, List<Tuple2<N, N>>> findShortestPath(Graph<N> graph, N n, N n2, Function2<N, N, V> function2, Numeric<V> numeric) {
        return Graph$.MODULE$.findShortestPath(graph, n, n2, function2, numeric);
    }

    public static <N, V> Map<N, V> findShortestPaths(Graph<N> graph, N n, Function2<N, N, V> function2, Numeric<V> numeric) {
        return Graph$.MODULE$.findShortestPaths(graph, n, function2, numeric);
    }

    public static <N, V> Map<N, V> findShortestPaths(Graph<N> graph, N n, Numeric<V> numeric) {
        return Graph$.MODULE$.findShortestPaths(graph, n, numeric);
    }

    public static <N> Traversable<Traversable<N>> findStronglyConnectedComponents(Graph<N> graph) {
        return Graph$.MODULE$.findStronglyConnectedComponents(graph);
    }

    public static <N> boolean hasCycles(Graph<N> graph) {
        return Graph$.MODULE$.hasCycles(graph);
    }

    public static <N> Traversable<N> leavesOf(Graph<N> graph) {
        return Graph$.MODULE$.leavesOf(graph);
    }

    public static <N> Graph<N> merge(Graph<N> graph, Graph<N> graph2) {
        return Graph$.MODULE$.merge(graph, graph2);
    }

    public static <N> MutableMapGraph<N> mergeNodes(Graph<N> graph, N n, N n2) {
        return Graph$.MODULE$.mergeNodes(graph, n, n2);
    }

    public static <N> Graph<N> predecessorsAndSuccessorsOf(Graph<N> graph, N n) {
        return Graph$.MODULE$.predecessorsAndSuccessorsOf(graph, n);
    }

    public static <N> Graph<N> predecessorsAndSuccessorsOf(Graph<N> graph, Seq<N> seq) {
        return Graph$.MODULE$.predecessorsAndSuccessorsOf(graph, seq);
    }

    public static <N> Graph<N> predecessorsOf(Graph<N> graph, N n) {
        return Graph$.MODULE$.predecessorsOf(graph, n);
    }

    public static <N> Graph<N> predecessorsOf(Graph<N> graph, Seq<N> seq) {
        return Graph$.MODULE$.predecessorsOf(graph, seq);
    }

    public static <N> int randomCutCount(Graph<N> graph) {
        return Graph$.MODULE$.randomCutCount(graph);
    }

    public static Graph<Object> readFromAdjacentListFile(Source source) {
        return Graph$.MODULE$.readFromAdjacentListFile(source);
    }

    public static Graph<Object> readFromAdjacentWeightListFile(Source source) {
        return Graph$.MODULE$.readFromAdjacentWeightListFile(source);
    }

    public static Graph<Object> readFromEdgeListFile(Source source, boolean bl) {
        return Graph$.MODULE$.readFromEdgeListFile(source, bl);
    }

    public static <N> Traversable<N> rootsOf(Graph<N> graph) {
        return Graph$.MODULE$.rootsOf(graph);
    }

    public static <N> List<N> sortTopologically(Graph<N> graph) {
        return Graph$.MODULE$.sortTopologically(graph);
    }

    public static <N> Graph<N> successorsOf(Graph<N> graph, N n) {
        return Graph$.MODULE$.successorsOf(graph, n);
    }

    public static <N> Graph<N> successorsOf(Graph<N> graph, Seq<N> seq) {
        return Graph$.MODULE$.successorsOf(graph, seq);
    }

    public static boolean readFromEdgeListFile$default$2() {
        return Graph$.MODULE$.readFromEdgeListFile$default$2();
    }

    public static <N> scala.collection.mutable.Map<N, Object> findCycles$default$3() {
        return Graph$.MODULE$.findCycles$default$3();
    }

    public static <N> HashSet<N> bfs$default$4() {
        return Graph$.MODULE$.bfs$default$4();
    }

    public static <N> HashSet<N> dfs$default$4() {
        return Graph$.MODULE$.dfs$default$4();
    }

    public static <N> HashSet<N> dfsi$default$4() {
        return Graph$.MODULE$.dfsi$default$4();
    }

    public Traversable<N> nodes();

    public Function1<N, Traversable<N>> adjacent();

    public boolean hasAdjacent(N var1);

    public Traversable<Tuple2<N, N>> edges();

    public boolean contains(N var1);

    public Graph<N> reverse();

    public int nodesCount();

    public long edgesCount();

    public static interface DfsVisitor<N> {
        public static void start$(DfsVisitor $this, Object node) {
            $this.start(node);
        }

        default public void start(N node) {
        }

        public static void before$(DfsVisitor $this, Object node) {
            $this.before(node);
        }

        default public void before(N node) {
        }

        public static void edge$(DfsVisitor $this, Tuple2 edge) {
            $this.edge(edge);
        }

        default public void edge(Tuple2<N, N> edge) {
        }

        public static void after$(DfsVisitor $this, Object node) {
            $this.after(node);
        }

        default public void after(N node) {
        }
    }

    public static final class GenericGraphImpl<N>
    implements GenericGraph<N> {
        private final Traversable<N> nodes;
        private final Function1<N, Traversable<N>> adjacent;

        public GenericGraphImpl(Traversable<N> nodes, Function1<N, Traversable<N>> adjacent) {
            this.nodes = nodes;
            this.adjacent = adjacent;
        }

        @Override
        public Traversable<N> nodes() {
            return this.nodes;
        }

        @Override
        public Function1<N, Traversable<N>> adjacent() {
            return this.adjacent;
        }

        @Override
        public boolean hasAdjacent(N node) {
            Traversable Traversable_this = (Traversable)this.adjacent().apply(node);
            return !Traversable_this.isEmpty();
        }
    }

    public static final class WeightedGraphImpl<N, V>
    implements GenericGraph<N>,
    Weighted<N, V> {
        private final Traversable<N> nodes;
        private final Function1<N, Traversable<N>> adjacent;
        private final Function2<N, N, V> weight;

        public WeightedGraphImpl(Traversable<N> nodes, Function1<N, Traversable<N>> adjacent, Function2<N, N, V> weight, Numeric<V> evidence$1) {
            this.nodes = nodes;
            this.adjacent = adjacent;
            this.weight = weight;
        }

        @Override
        public Traversable<N> nodes() {
            return this.nodes;
        }

        @Override
        public Function1<N, Traversable<N>> adjacent() {
            return this.adjacent;
        }

        @Override
        public Function2<N, N, V> weight() {
            return this.weight;
        }

        @Override
        public boolean hasAdjacent(N node) {
            Traversable Traversable_this = (Traversable)this.adjacent().apply(node);
            return !Traversable_this.isEmpty();
        }
    }
}

