/*
 * Decompiled with CFR 0.152.
 */
package org.encalmo.data;

import java.io.Serializable;
import org.encalmo.data.GenericGraph;
import org.encalmo.data.Graph;
import org.encalmo.data.Mutable;
import org.encalmo.data.MutableMapGraph$;
import org.encalmo.data.Traversable;
import org.encalmo.data.Traversable$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Shrinkable;
import scala.math.Ordering;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MutableMapGraph<N>
implements GenericGraph<N>,
Mutable<N> {
    private final Map<N, ArrayBuffer<N>> nodeMap;
    private final Function1<N, Traversable<N>> adjacent;

    public static <N> HashMap<N, ArrayBuffer<N>> $lessinit$greater$default$1() {
        return MutableMapGraph$.MODULE$.$lessinit$greater$default$1();
    }

    public MutableMapGraph(Map<N, ArrayBuffer<N>> nodeMap) {
        this.nodeMap = nodeMap;
        Growable.$init$((Growable)this);
        Shrinkable.$init$((Shrinkable)this);
        this.adjacent = nodeMap.view().mapValues((Function1 & Serializable)v -> {
            Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
            return new Traversable<N>((ArrayBuffer)v){
                private final ArrayBuffer v$1;
                {
                    this.v$1 = v$2;
                }

                public void foreach(Function1 f) {
                    this.v$1.foreach(f);
                }

                public boolean exists(Function1 p) {
                    return this.v$1.exists(p);
                }

                public Option find(Function1 p) {
                    return this.v$1.find(p);
                }

                public Object foldLeft(Object initial, Function2 f) {
                    return this.v$1.foldLeft(initial, f);
                }

                public int size() {
                    return this.v$1.size();
                }

                public boolean isEmpty() {
                    return this.v$1.isEmpty();
                }

                public scala.collection.immutable.Seq toSeq() {
                    return this.v$1.toSeq();
                }

                public Seq toMutableSeq() {
                    if (this.v$1 instanceof Seq) {
                        return this.v$1;
                    }
                    return Traversable.toMutableSeq$(this);
                }

                public String toString() {
                    return this.v$1.toString();
                }

                public Object minBy(Function1 f, Ordering ord) {
                    return this.v$1.minBy(f, ord);
                }

                public Object maxBy(Function1 f, Ordering ord) {
                    return this.v$1.maxBy(f, ord);
                }
            };
        });
    }

    public Map<N, ArrayBuffer<N>> nodeMap() {
        return this.nodeMap;
    }

    @Override
    public final Traversable<N> nodes() {
        Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
        Iterable x$proxy2 = this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().keys();
        return new Traversable<N>(x$proxy2){
            private final Iterable x$proxy2$1;
            {
                this.x$proxy2$1 = x$proxy2$2;
            }

            public void foreach(Function1 f) {
                this.x$proxy2$1.foreach(f);
            }

            public boolean exists(Function1 p) {
                return this.x$proxy2$1.exists(p);
            }

            public Option find(Function1 p) {
                return this.x$proxy2$1.find(p);
            }

            public Object foldLeft(Object initial, Function2 f) {
                return this.x$proxy2$1.foldLeft(initial, f);
            }

            public int size() {
                return this.x$proxy2$1.size();
            }

            public boolean isEmpty() {
                return this.x$proxy2$1.isEmpty();
            }

            public scala.collection.immutable.Seq toSeq() {
                return this.x$proxy2$1.toSeq();
            }

            public Seq toMutableSeq() {
                if (this.x$proxy2$1 instanceof Seq) {
                    return (Seq)this.x$proxy2$1;
                }
                return Traversable.toMutableSeq$(this);
            }

            public String toString() {
                return this.x$proxy2$1.toString();
            }

            public Object minBy(Function1 f, Ordering ord) {
                return this.x$proxy2$1.minBy(f, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return this.x$proxy2$1.maxBy(f, ord);
            }
        };
    }

    @Override
    public final int nodesCount() {
        return this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().size();
    }

    @Override
    public final boolean contains(N node) {
        return this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().contains(node);
    }

    @Override
    public Function1<N, Traversable<N>> adjacent() {
        return this.adjacent;
    }

    @Override
    public boolean hasAdjacent(N node) {
        return this.nodeMap().get(node).exists((Function1 & Serializable)_$2 -> _$2.nonEmpty());
    }

    @Override
    public Graph<N> reverse() {
        MutableMapGraph MutableMapGraph_this = new MutableMapGraph<N>(this){
            public static final long OFFSET$0;
            private volatile Object reverse$lzy3;
            private final /* synthetic */ MutableMapGraph $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$8.class.getDeclaredField("reverse$lzy3"));
            }

            public Graph reverse() {
                Object object = this.reverse$lzy3;
                if (object instanceof Graph) {
                    return (Graph)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (Graph)this.reverse$lzyINIT3();
            }

            private Object reverse$lzyINIT3() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.reverse$lzy3) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            MutableMapGraph mutableMapGraph = null;
                            try {
                                mutableMapGraph = this.$outer;
                                object2 = mutableMapGraph == null ? LazyVals.NullValue$.MODULE$ : mutableMapGraph;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.reverse$lzy3;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return mutableMapGraph;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }
        };
        Traversable edges$proxy2 = this.edges();
        edges$proxy2.foreach((Function1 & Serializable)edge -> (MutableMapGraph)MutableMapGraph_this.$plus$eq(edge.swap()));
        return MutableMapGraph_this;
    }

    public final MutableMapGraph addOne(Tuple2<N, N> edge) {
        ((ArrayBuffer)this.nodeMap().getOrElseUpdate(edge._1(), MutableMapGraph::addOne$$anonfun$1)).addOne(edge._2());
        this.nodeMap().getOrElseUpdate(edge._2(), MutableMapGraph::addOne$$anonfun$2);
        return this;
    }

    public final MutableMapGraph prependOne(Tuple2<N, N> edge) {
        ((ArrayBuffer)this.nodeMap().getOrElseUpdate(edge._1(), MutableMapGraph::prependOne$$anonfun$1)).prepend(edge._2());
        this.nodeMap().getOrElseUpdate(edge._2(), MutableMapGraph::prependOne$$anonfun$2);
        return this;
    }

    public final MutableMapGraph prependOneIfNotExist(Tuple2<N, N> edge) {
        this.nodeMap().updateWith(edge._1(), (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ArrayBuffer existing = (ArrayBuffer)((Some)option).value();
                if (!existing.contains(edge._2())) {
                    return Some$.MODULE$.apply((Object)existing.prepend(edge._2()));
                }
                return Some$.MODULE$.apply((Object)existing);
            }
            if (None$.MODULE$.equals(option)) {
                return Some$.MODULE$.apply(ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{edge._2()})));
            }
            throw new MatchError((Object)option);
        });
        this.nodeMap().updateWith(edge._2(), (Function1 & Serializable)_$3 -> _$3.orElse(MutableMapGraph::prependOneIfNotExist$$anonfun$2$$anonfun$1));
        return this;
    }

    public final MutableMapGraph subtractOne(Tuple2<N, N> edge) {
        this.nodeMap().get(edge._1()).foreach((Function1 & Serializable)adjacent -> {
            ArrayBuffer a = adjacent;
            return (ArrayBuffer)a.$minus$eq(edge._2());
        });
        return this;
    }

    @Override
    public final MutableMapGraph remove(N node) {
        this.nodeMap().subtractOne(node);
        return this;
    }

    @Override
    public final MutableMapGraph transform(Function2<N, ArrayBuffer<N>, ArrayBuffer<N>> f) {
        this.nodeMap().mapValuesInPlace(f);
        return this;
    }

    @Override
    public final MutableMapGraph update(N node, ArrayBuffer<N> adjacent) {
        this.nodeMap().update(node, adjacent);
        return this;
    }

    public final Tuple2<N, ArrayBuffer<N>> head() {
        return (Tuple2)this.nodeMap().head();
    }

    public final void clear() {
        this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().clear();
    }

    public final MutableMapGraph<N> merge(MutableMapGraph<N> other) {
        if (other.nodeMap().isEmpty()) {
            return this;
        }
        if (this.nodeMap().isEmpty()) {
            return other;
        }
        HashMap mergedNodeMap = new HashMap();
        this.nodeMap().foreach((Function1 & Serializable)elem -> mergedNodeMap.addOne(elem));
        other.nodeMap().foreach((Function1 & Serializable)x$12 -> {
            Object object = x$12._1();
            ArrayBuffer arrayBuffer = (ArrayBuffer)x$12._2();
            return mergedNodeMap.updateWith(object, (Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    ArrayBuffer existing = (ArrayBuffer)((Some)option).value();
                    if (arrayBuffer.isEmpty()) {
                        return Some$.MODULE$.apply((Object)existing);
                    }
                    if (existing.isEmpty()) {
                        return Some$.MODULE$.apply((Object)arrayBuffer);
                    }
                    ArrayBuffer adjacent = ArrayBuffer$.MODULE$.from((IterableOnce)existing);
                    arrayBuffer.foreach((Function1)(JProcedure1 & Serializable)n -> {
                        if (!adjacent.contains(n)) {
                            adjacent.addOne(n);
                            return;
                        }
                    });
                    return Some$.MODULE$.apply((Object)adjacent);
                }
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply((Object)arrayBuffer);
                }
                throw new MatchError((Object)option);
            });
        });
        return new MutableMapGraph<N>(mergedNodeMap);
    }

    public Map<N, ArrayBuffer<N>> org$encalmo$data$MutableMapGraph$$inline$nodeMap() {
        return this.nodeMap();
    }

    private static final ArrayBuffer addOne$$anonfun$1() {
        return new ArrayBuffer();
    }

    private static final ArrayBuffer addOne$$anonfun$2() {
        return new ArrayBuffer();
    }

    private static final ArrayBuffer prependOne$$anonfun$1() {
        return new ArrayBuffer();
    }

    private static final ArrayBuffer prependOne$$anonfun$2() {
        return new ArrayBuffer();
    }

    private static final Option prependOneIfNotExist$$anonfun$2$$anonfun$1() {
        return Some$.MODULE$.apply((Object)ArrayBuffer$.MODULE$.empty());
    }
}

