/*
 * Decompiled with CFR 0.152.
 */
package org.encalmo.data;

import java.io.Serializable;
import org.encalmo.data.Graph;
import org.encalmo.data.Graph$GraphCycleFoundException$;
import org.encalmo.data.MinHeap;
import org.encalmo.data.MutableMapGraph;
import org.encalmo.data.MutableMapGraph$;
import org.encalmo.data.QuickSort$;
import org.encalmo.data.Traversable;
import org.encalmo.data.Traversable$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.io.Source;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

public final class Graph$
implements Serializable {
    public static final Graph$GraphCycleFoundException$ GraphCycleFoundException;
    public static final Graph$ MODULE$;

    private Graph$() {
    }

    static {
        MODULE$ = new Graph$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Graph$.class);
    }

    public <N> MutableMapGraph<N> apply() {
        return new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
    }

    public <N, V> Graph<N> apply(scala.collection.immutable.Seq<Tuple2<N, Iterable<Tuple2<N, V>>>> mappings, Numeric<V> evidence$1) {
        scala.collection.immutable.Map nodeWeightMap = (scala.collection.immutable.Map)mappings.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Iterable v = (Iterable)tuple2._2();
                return Tuple2$.MODULE$.apply(k, (Object)v.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            throw new MatchError((Object)tuple2);
        });
        Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
        Iterable x$proxy4 = nodeWeightMap.keys();
        return new Graph.WeightedGraphImpl(new Traversable.TraversableFromIterable(x$proxy4), nodeWeightMap.view().mapValues((Function1 & Serializable)x$1 -> {
            scala.collection.immutable.Map map;
            scala.collection.immutable.Map m = map = x$1;
            Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
            Iterable x$proxy5 = m.keys();
            return new Traversable.TraversableFromIterable(x$proxy5);
        }), (Function2 & Serializable)(t, h) -> ((MapOps)nodeWeightMap.apply(t)).apply(h), evidence$1);
    }

    public Graph<Object> readFromEdgeListFile(Source path, boolean reversed) {
        Iterator edges = path.getLines().map((Function1 & Serializable)line -> {
            int i = line.indexOf(32);
            int tail = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(line.substring(0, i)));
            int head = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(line.substring(i + 1).trim()));
            if (reversed) {
                return new Tuple2.mcII.sp(head, tail);
            }
            return new Tuple2.mcII.sp(tail, head);
        });
        return (MutableMapGraph)new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1()).addAll((IterableOnce)edges);
    }

    public boolean readFromEdgeListFile$default$2() {
        return false;
    }

    public Graph<Object> readFromAdjacentListFile(Source path) {
        scala.collection.mutable.Map nodeMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        path.getLines().withFilter((Function1 & Serializable)line -> !line.trim().isEmpty()).foreach((Function1)(JProcedure1 & Serializable)line -> {
            Tuple2 tuple2 = this.parseNodeAdjacentList$1((String)line);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int node = BoxesRunTime.unboxToInt((Object)tuple2._1());
            scala.collection.immutable.Seq adjacent = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)node), (Object)adjacent);
            int node2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
            scala.collection.immutable.Seq adjacent2 = (scala.collection.immutable.Seq)tuple22._2();
            Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
            nodeMap.update((Object)BoxesRunTime.boxToInteger((int)node2), (Object)new Traversable.IntTraversableFromIterable((Iterable<Object>)adjacent2));
        });
        Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
        Iterable x$proxy6 = nodeMap.keys();
        return new Graph.GenericGraphImpl<Object>(new Traversable.IntTraversableFromIterable((Iterable<Object>)x$proxy6), (Function1<Object, Traversable<Object>>)nodeMap);
    }

    public Graph<Object> readFromAdjacentWeightListFile(Source path) {
        scala.collection.mutable.Map nodeWeightMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        path.getLines().withFilter((Function1 & Serializable)line -> !line.trim().isEmpty()).foreach((Function1)(JProcedure1 & Serializable)line -> {
            Tuple2 tuple2 = this.parseNodeWeightAdjacentList$1((String)line);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int node = BoxesRunTime.unboxToInt((Object)tuple2._1());
            scala.collection.immutable.Map list = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)node), (Object)list);
            int node2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
            scala.collection.immutable.Map list2 = (scala.collection.immutable.Map)tuple22._2();
            nodeWeightMap.update((Object)BoxesRunTime.boxToInteger((int)node2), (Object)list2);
        });
        Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
        Iterable x$proxy7 = nodeWeightMap.keys();
        return new Graph.WeightedGraphImpl(new Traversable.IntTraversableFromIterable((Iterable<Object>)x$proxy7), nodeWeightMap.view().mapValues((Function1 & Serializable)x$1 -> {
            scala.collection.immutable.Map map;
            scala.collection.immutable.Map m = map = x$1;
            Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
            Iterable x$proxy8 = m.keys();
            return new Traversable.IntTraversableFromIterable((Iterable<Object>)x$proxy8);
        }), (JFunction2.mcIII.sp & Serializable)(t, h) -> ((Function1)nodeWeightMap.apply((Object)BoxesRunTime.boxToInteger((int)t))).apply$mcII$sp(h), Numeric.IntIsIntegral$.MODULE$);
    }

    public <N> void dfs(Graph<N> graph, Graph.DfsVisitor<N> visitor, Traversable<N> nodes) {
        HashSet explored = new HashSet();
        nodes.foreach((JProcedure1 & Serializable)node -> {
            if (!explored.contains(node)) {
                visitor.start(node);
                MODULE$.dfsi(graph, node, visitor, explored);
                return;
            }
        });
    }

    public <N> void dfs(Graph<N> graph, N node, Graph.DfsVisitor<N> visitor, HashSet<N> explored) {
        if (!explored.contains(node)) {
            explored.add(node);
            visitor.before(node);
            ((Traversable)graph.adjacent().apply(node)).withFilter((Function1 & Serializable)next -> !explored.contains(next)).foreach((JProcedure1 & Serializable)next -> {
                visitor.edge(Tuple2$.MODULE$.apply(node, next));
                MODULE$.dfs(graph, next, visitor, explored);
            });
            visitor.after(node);
            return;
        }
    }

    public <N> HashSet<N> dfs$default$4(Graph<N> graph) {
        return (HashSet)HashSet$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public <N> void dfsi(Graph<N> graph, N source, Graph.DfsVisitor<N> visitor, HashSet<N> explored) {
        Stack stack = new Stack(Stack$.MODULE$.$lessinit$greater$default$1());
        explored.add(source);
        stack.push(source);
        visitor.before(source);
        while (!stack.isEmpty()) {
            Object node = stack.top();
            Option option = ((Traversable)graph.adjacent().apply(node)).find((Function1 & Serializable)n -> !explored.contains(n));
            if (option instanceof Some) {
                Object next = ((Some)option).value();
                explored.add(next);
                stack.push(next);
                visitor.edge(Tuple2$.MODULE$.apply(node, next));
                visitor.before(next);
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                stack.pop();
                visitor.after(node);
                continue;
            }
            throw new MatchError(option);
        }
    }

    public <N> HashSet<N> dfsi$default$4(Graph<N> graph) {
        return (HashSet)HashSet$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public <N> void bfs(Graph<N> graph, Function1<N, BoxedUnit> visitor) {
        HashSet explored = (HashSet)HashSet$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        graph.nodes().foreach((JProcedure1 & Serializable)node -> {
            if (!explored.contains(node)) {
                MODULE$.bfs(graph, node, visitor, explored);
                return;
            }
        });
    }

    public <N> void bfs(Graph<N> graph, N node, Function1<N, BoxedUnit> visitor, HashSet<N> explored) {
        Queue queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        queue.enqueue(node);
        while (!queue.isEmpty()) {
            Object n = queue.dequeue();
            if (explored.contains(n)) continue;
            explored.add(n);
            visitor.apply(n);
            ((Traversable)graph.adjacent().apply(n)).foreach((Function1 & Serializable)next -> queue.enqueue(next));
        }
    }

    public <N> HashSet<N> bfs$default$4(Graph<N> graph) {
        return (HashSet)HashSet$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public <N> Vector<N> findCycles(Graph<N> graph) {
        ObjectRef cycles = ObjectRef.create((Object)package$.MODULE$.Vector().empty());
        scala.collection.mutable.Map marks = new HashMap().withDefaultValue((Object)BoxesRunTime.boxToCharacter((char)'0'));
        graph.nodes().withFilter((Function1 & Serializable)node -> BoxesRunTime.unboxToChar((Object)marks.apply(node)) == '0').foreach((JProcedure1 & Serializable)node -> {
            cycles$1.elem = (Vector)((Vector)cycles$1.elem).$plus$plus(MODULE$.findCycles(graph, node, marks));
        });
        return (Vector)cycles.elem;
    }

    public <N> Vector<N> findCycles(Graph<N> graph, N node, scala.collection.mutable.Map<N, Object> marks) {
        ObjectRef cycles = ObjectRef.create((Object)package$.MODULE$.Vector().empty());
        if (BoxesRunTime.unboxToChar((Object)marks.apply(node)) == 'x') {
            cycles.elem = (Vector)((Vector)cycles.elem).$colon$plus(node);
        } else if (BoxesRunTime.unboxToChar((Object)marks.apply(node)) == '0') {
            marks.update(node, (Object)BoxesRunTime.boxToCharacter((char)'x'));
            ((Traversable)graph.adjacent().apply(node)).foreach((JProcedure1 & Serializable)next -> {
                cycles$2.elem = (Vector)((Vector)cycles$2.elem).$plus$plus(MODULE$.findCycles(graph, next, marks));
            });
            marks.update(node, (Object)BoxesRunTime.boxToCharacter((char)'1'));
        }
        return (Vector)cycles.elem;
    }

    public <N> scala.collection.mutable.Map<N, Object> findCycles$default$3(Graph<N> graph) {
        return new HashMap().withDefaultValue((Object)BoxesRunTime.boxToCharacter((char)'0'));
    }

    public <N> boolean hasCycles(Graph<N> graph) {
        boolean bl;
        scala.collection.mutable.Map marks = new HashMap().withDefaultValue((Object)BoxesRunTime.boxToCharacter((char)'0'));
        try {
            graph.nodes().withFilter((Function1 & Serializable)node -> BoxesRunTime.unboxToChar((Object)marks.apply(node)) == '0').foreach((JProcedure1 & Serializable)node -> this.checkCycles$1(marks, graph, node));
            bl = false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (Graph$GraphCycleFoundException$.MODULE$.equals(throwable2)) {
                bl = true;
            }
            throw throwable;
        }
        return bl;
    }

    public <N> List<N> sortTopologically(Graph<N> graph) {
        IntRef counter = IntRef.create((int)graph.nodesCount());
        ObjectRef priorities = ObjectRef.create((Object)package$.MODULE$.Nil());
        Graph.DfsVisitor observer = new Graph.DfsVisitor<N>(priorities, counter){
            private final ObjectRef priorities$1;
            private final IntRef counter$1;
            {
                this.priorities$1 = priorities$2;
                this.counter$1 = counter$2;
            }

            public void after(Object node) {
                this.priorities$1.elem = ((List)this.priorities$1.elem).$colon$colon(node);
                --this.counter$1.elem;
            }
        };
        this.dfs(graph, observer, graph.nodes());
        return (List)priorities.elem;
    }

    public <N> Traversable<Traversable<N>> findStronglyConnectedComponents(Graph<N> graph) {
        Graph<N> reversed = graph.reverse();
        Seq<N> nodes = graph.nodes().toMutableSeq();
        HashMap times = new HashMap();
        Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
        this.dfs(reversed, new Graph.DfsVisitor<N>(times){
            private final HashMap times$1;
            private int time;
            {
                this.times$1 = times$3;
                this.time = 0;
            }

            public int time() {
                return this.time;
            }

            public void time_$eq(int x$1) {
                this.time = x$1;
            }

            public void after(Object node) {
                this.time_$eq(this.time() + 1);
                this.times$1.update(node, (Object)BoxesRunTime.boxToInteger((int)this.time()));
            }
        }, new Traversable.TraversableFromIterable<N>(nodes));
        Ordering ordering = new Ordering<N>(times){
            private final HashMap times$2;
            {
                this.times$2 = times$4;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }

            public int compare(Object x, Object y) {
                return BoxesRunTime.unboxToInt((Object)this.times$2.apply(y)) - BoxesRunTime.unboxToInt((Object)this.times$2.apply(x));
            }
        };
        QuickSort$.MODULE$.sort(nodes, 0, nodes.length(), (Function3 & Serializable)(array, start, end) -> QuickSort$.MODULE$.random((Seq)array, BoxesRunTime.unboxToInt((Object)start), BoxesRunTime.unboxToInt((Object)end)), ordering);
        HashMap leaders = new HashMap();
        Traversable.fromIterable fromIterable_this2 = Traversable$.MODULE$.fromIterable();
        this.dfs(graph, new Graph.DfsVisitor<N>(leaders){
            private final HashMap leaders$1;
            private Option leader;
            {
                this.leaders$1 = leaders$2;
                this.leader = None$.MODULE$;
            }

            public Option leader() {
                return this.leader;
            }

            public void leader_$eq(Option x$1) {
                this.leader = x$1;
            }

            public void start(Object node) {
                this.leader_$eq((Option)Some$.MODULE$.apply(node));
            }

            public void before(Object node) {
                this.leaders$1.update(node, this.leader().get());
            }
        }, new Traversable.TraversableFromIterable<N>(nodes));
        return graph.nodes().sortedValuesOfGroupBy(leaders, (Function1<Iterable<N>, Object>)(Function1 & Serializable)c -> -c.size());
    }

    public <N> MutableMapGraph<N> mergeNodes(Graph<N> graph, N mergedNode, N removedNode) {
        MutableMapGraph mutableMapGraph;
        Graph<N> graph2 = graph;
        if (graph2 instanceof MutableMapGraph) {
            MutableMapGraph x;
            mutableMapGraph = x = (MutableMapGraph)graph2;
        } else {
            MutableMapGraph MutableMapGraph_this = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
            Traversable<Tuple2<N, N>> xs$proxy1 = graph.edges();
            xs$proxy1.foreach((Function1 & Serializable)edge -> MutableMapGraph_this.addOne(edge));
            mutableMapGraph = MutableMapGraph_this;
        }
        MutableMapGraph g = mutableMapGraph;
        Traversable removedAdjacent = (Traversable)g.adjacent().apply(removedNode);
        Traversable mergedAdjacent = (Traversable)g.adjacent().apply(mergedNode);
        ArrayBuffer newAdjacent = new ArrayBuffer(removedAdjacent.size() + mergedAdjacent.size());
        mergedAdjacent.foreach((JProcedure1 & Serializable)node -> {
            if (!BoxesRunTime.equals((Object)node, (Object)removedNode)) {
                newAdjacent.addOne(node);
                return;
            }
        });
        removedAdjacent.foreach((JProcedure1 & Serializable)node -> {
            if (!BoxesRunTime.equals((Object)node, (Object)mergedNode)) {
                newAdjacent.addOne(node);
                return;
            }
        });
        g.remove((Object)removedNode);
        g.update((Object)mergedNode, newAdjacent);
        g.transform((Function2 & Serializable)(_$7, adjacent) -> {
            if (adjacent.contains(removedNode)) {
                return (ArrayBuffer)adjacent.map((Function1 & Serializable)x$1 -> {
                    Object object = x$1;
                    Object n = object;
                    if (BoxesRunTime.equals((Object)n, (Object)removedNode)) {
                        return mergedNode;
                    }
                    Object n2 = object;
                    return n2;
                });
            }
            return adjacent;
        });
        return g;
    }

    public <N> int randomCutCount(Graph<N> graph) {
        MutableMapGraph MutableMapGraph_this;
        MutableMapGraph g;
        MutableMapGraph mutableMapGraph;
        Graph<N> graph2 = graph;
        if (graph2 instanceof MutableMapGraph) {
            MutableMapGraph x;
            mutableMapGraph = x = (MutableMapGraph)graph2;
        } else {
            MutableMapGraph MutableMapGraph_this2 = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
            Traversable<Tuple2<N, N>> xs$proxy2 = graph.edges();
            xs$proxy2.foreach((Function1 & Serializable)edge -> MutableMapGraph_this2.addOne(edge));
            mutableMapGraph = MutableMapGraph_this2;
        }
        MutableMapGraph MutableMapGraph_this3 = g = mutableMapGraph;
        Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
        Iterable x$proxy9 = MutableMapGraph_this3.org$encalmo$data$MutableMapGraph$$inline$nodeMap().keys();
        Queue nodesQueue = this.randomizedQueue$1(new Traversable.TraversableFromIterable(x$proxy9));
        while ((MutableMapGraph_this = g).org$encalmo$data$MutableMapGraph$$inline$nodeMap().size() > 2) {
            Object node1 = nodesQueue.dequeue();
            Traversable adjacent = (Traversable)g.adjacent().apply(node1);
            if (adjacent.size() <= 0) continue;
            int j = (int)(Math.random() * (double)adjacent.size());
            Object node2 = adjacent.get(j);
            this.mergeNodes(g, node2, node1);
        }
        Tuple2 tuple2 = g.head();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayBuffer adjacent = (ArrayBuffer)tuple2._2();
        ArrayBuffer adjacent2 = adjacent;
        return adjacent2.size();
    }

    public <N> Graph<N> merge(Graph<N> graph, Graph<N> graph2) {
        MutableMapGraph mutableMapGraph;
        MutableMapGraph mutableMapGraph2;
        Graph<N> graph3 = graph;
        if (graph3 instanceof MutableMapGraph) {
            MutableMapGraph x;
            mutableMapGraph2 = x = (MutableMapGraph)graph3;
        } else {
            MutableMapGraph MutableMapGraph_this = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
            Traversable<Tuple2<N, N>> xs$proxy3 = graph.edges();
            xs$proxy3.foreach((Function1 & Serializable)edge -> MutableMapGraph_this.addOne(edge));
            mutableMapGraph2 = MutableMapGraph_this;
        }
        Graph<N> graph4 = graph2;
        if (graph4 instanceof MutableMapGraph) {
            MutableMapGraph x;
            mutableMapGraph = x = (MutableMapGraph)graph4;
        } else {
            MutableMapGraph MutableMapGraph_this = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
            Traversable<Tuple2<N, N>> xs$proxy4 = graph2.edges();
            xs$proxy4.foreach((Function1 & Serializable)edge -> MutableMapGraph_this.addOne(edge));
            mutableMapGraph = MutableMapGraph_this;
        }
        return mutableMapGraph2.merge(mutableMapGraph);
    }

    public <N> Traversable<N> leavesOf(Graph<N> graph) {
        return graph.nodes().filterNot((Function1 & Serializable)n -> graph.hasAdjacent(n));
    }

    public <N> Traversable<N> rootsOf(Graph<N> graph) {
        Graph reversed = graph.reverse();
        return reversed.nodes().filterNot((Function1 & Serializable)n -> reversed.hasAdjacent(n));
    }

    public <N> Graph<N> successorsOf(Graph<N> graph, N node) {
        MutableMapGraph result = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
        Queue queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        queue.enqueue(node);
        while (!queue.isEmpty()) {
            Object n = queue.dequeue();
            MutableMapGraph MutableMapGraph_this = result;
            if (MutableMapGraph_this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().contains(n)) continue;
            Traversable adjacent = (Traversable)graph.adjacent().apply(n);
            result.update(n, adjacent.toArrayBuffer());
            adjacent.foreach((Function1 & Serializable)next -> queue.enqueue(next));
        }
        return result;
    }

    public <N> Graph<N> successorsOf(Graph<N> graph, scala.collection.immutable.Seq<N> nodes) {
        MutableMapGraph result = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
        Queue queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        queue.enqueueAll(nodes);
        while (!queue.isEmpty()) {
            Object n = queue.dequeue();
            MutableMapGraph MutableMapGraph_this = result;
            if (MutableMapGraph_this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().contains(n)) continue;
            Traversable adjacent = (Traversable)graph.adjacent().apply(n);
            result.update(n, adjacent.toArrayBuffer());
            adjacent.foreach((Function1 & Serializable)next -> queue.enqueue(next));
        }
        return result;
    }

    public <N> Graph<N> predecessorsOf(Graph<N> graph, N node) {
        Graph<N> reversed = graph.reverse();
        MutableMapGraph result = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
        HashSet explored = (HashSet)HashSet$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Queue queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        queue.enqueue(node);
        while (!queue.isEmpty()) {
            Object n = queue.dequeue();
            if (explored.contains(n)) continue;
            explored.add(n);
            Traversable adjacent = (Traversable)reversed.adjacent().apply(n);
            adjacent.foreach((Function1 & Serializable)next -> {
                result.prependOne(Tuple2$.MODULE$.apply(next, n));
                return queue.enqueue(next);
            });
        }
        return result;
    }

    public <N> Graph<N> predecessorsOf(Graph<N> graph, scala.collection.immutable.Seq<N> nodes) {
        Graph<N> reversed = graph.reverse();
        MutableMapGraph result = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
        HashSet explored = (HashSet)HashSet$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Queue queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        queue.enqueueAll(nodes);
        while (!queue.isEmpty()) {
            Object n = queue.dequeue();
            if (explored.contains(n)) continue;
            explored.add(n);
            Traversable adjacent = (Traversable)reversed.adjacent().apply(n);
            adjacent.foreach((Function1 & Serializable)next -> {
                result.prependOne(Tuple2$.MODULE$.apply(next, n));
                return queue.enqueue(next);
            });
        }
        return result;
    }

    public <N> Graph<N> predecessorsAndSuccessorsOf(Graph<N> graph, N node) {
        LazyRef lazyRef = new LazyRef();
        MutableMapGraph result = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
        Queue queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        queue.enqueue(node);
        while (!queue.isEmpty()) {
            Object n = queue.dequeue();
            MutableMapGraph MutableMapGraph_this = result;
            if (MutableMapGraph_this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().contains(n)) continue;
            Traversable adjacent = (Traversable)graph.adjacent().apply(n);
            result.update(n, adjacent.toArrayBuffer());
            adjacent.foreach((Function1 & Serializable)next -> queue.enqueue(next));
        }
        MutableMapGraph MutableMapGraph_this = result;
        Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
        Iterable x$proxy10 = MutableMapGraph_this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().keys();
        HashSet explored = (HashSet)new Traversable.TraversableFromIterable(x$proxy10).toHashSet().$minus(node);
        queue.enqueue(node);
        while (!queue.isEmpty()) {
            Object n = queue.dequeue();
            if (explored.contains(n)) continue;
            explored.add(n);
            Traversable adjacent = (Traversable)this.reversed$3(lazyRef, graph).adjacent().apply(n);
            adjacent.foreach((Function1 & Serializable)next -> {
                result.prependOneIfNotExist(Tuple2$.MODULE$.apply(next, n));
                return queue.enqueue(next);
            });
        }
        return result;
    }

    public <N> Graph<N> predecessorsAndSuccessorsOf(Graph<N> graph, scala.collection.immutable.Seq<N> nodes) {
        LazyRef lazyRef = new LazyRef();
        MutableMapGraph result = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
        Queue queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        queue.enqueueAll(nodes);
        while (!queue.isEmpty()) {
            Object n = queue.dequeue();
            MutableMapGraph MutableMapGraph_this = result;
            if (MutableMapGraph_this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().contains(n)) continue;
            Traversable adjacent = (Traversable)graph.adjacent().apply(n);
            result.update(n, adjacent.toArrayBuffer());
            adjacent.foreach((Function1 & Serializable)next -> queue.enqueue(next));
        }
        MutableMapGraph MutableMapGraph_this = result;
        Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
        Iterable x$proxy11 = MutableMapGraph_this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().keys();
        HashSet explored = (HashSet)new Traversable.TraversableFromIterable(x$proxy11).toHashSet().$minus$minus(nodes);
        queue.enqueueAll(nodes);
        while (!queue.isEmpty()) {
            Object n = queue.dequeue();
            if (explored.contains(n)) continue;
            explored.add(n);
            Traversable adjacent = (Traversable)this.reversed$4(lazyRef, graph).adjacent().apply(n);
            adjacent.foreach((Function1 & Serializable)next -> {
                result.prependOneIfNotExist(Tuple2$.MODULE$.apply(next, n));
                return queue.enqueue(next);
            });
        }
        return result;
    }

    public <N, V> Tuple2<V, List<Tuple2<N, N>>> findShortestPath(Graph<N> graph, N from, N to, Function2<N, N, V> weight, Numeric<V> evidence$1) {
        Numeric num = (Numeric)Predef$.MODULE$.implicitly(evidence$1);
        if (BoxesRunTime.equals(from, to) || ((Traversable)graph.adjacent().apply(from)).isEmpty()) {
            return Tuple2$.MODULE$.apply(num.zero(), (Object)package$.MODULE$.Nil());
        }
        int nodesCount = graph.nodesCount();
        HashSet explored = new HashSet();
        HashMap distance = new HashMap();
        MutableMapGraph backtrace = new MutableMapGraph(MutableMapGraph$.MODULE$.$lessinit$greater$default$1());
        Ordering ordering = new Ordering<Tuple3<N, N, V>>(num, distance){
            private final Numeric num$1;
            private final HashMap distance$1;
            {
                this.num$1 = num$5;
                this.distance$1 = distance$6;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }

            public int compare(Tuple3 x, Tuple3 y) {
                return this.num$1.toInt(this.num$1.minus(this.num$1.plus(this.distance$1.apply(x._1()), x._3()), this.num$1.plus(this.distance$1.apply(y._1()), y._3())));
            }
        };
        MinHeap outgoingEdges = new MinHeap(Math.min(graph.nodesCount(), 1024), ordering);
        ObjectRef head = ObjectRef.create(from);
        explored.add(from);
        distance.update(from, num.zero());
        ObjectRef nextEdges = ObjectRef.create(((Traversable)graph.adjacent().apply(from)).filterNot(explored).map((Function1 & Serializable)node -> Tuple3$.MODULE$.apply(from, node, weight.apply(from, node))));
        outgoingEdges.insert((Traversable)nextEdges.elem);
        do {
            outgoingEdges.extract().foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                Tuple3 tuple3 = x$12;
                if (tuple3 != null) {
                    Object t = tuple3._1();
                    Object h = tuple3._2();
                    Object w = tuple3._3();
                    explored.add(h);
                    distance.update(h, num.plus(distance.apply(t), w));
                    backtrace.$plus$eq(Tuple2$.MODULE$.apply(h, t));
                    outgoingEdges.remove((Function1 & Serializable)x$1 -> {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 != null) {
                            Object node = tuple3._2();
                            return BoxesRunTime.equals((Object)node, (Object)h);
                        }
                        throw new MatchError((Object)tuple3);
                    });
                    nextEdges$1.elem = ((Traversable)graph.adjacent().apply(h)).filterNot(explored).map((Function1 & Serializable)node -> Tuple3$.MODULE$.apply(h, node, weight.apply(h, node)));
                    outgoingEdges.insert((Traversable)nextEdges$1.elem);
                    head$1.elem = h;
                    return;
                }
                throw new MatchError((Object)tuple3);
            });
        } while (!BoxesRunTime.equals((Object)head.elem, to) && !outgoingEdges.isEmpty() && explored.size() != nodesCount);
        Nil$ path = package$.MODULE$.Nil();
        if (BoxesRunTime.equals((Object)head.elem, to)) {
            N next = to;
            do {
                N node2 = next;
                next = ((Traversable)backtrace.adjacent().apply(node2)).minBy((Function1 & Serializable)n -> distance.apply(n), evidence$1);
                Tuple2 segment = Tuple2$.MODULE$.apply(next, node2);
                path = path.$colon$colon((Object)segment);
            } while (!BoxesRunTime.equals(next, from));
        }
        return Tuple2$.MODULE$.apply(distance.apply(to), (Object)path);
    }

    public <N, V> Map<N, V> findShortestPaths(Graph<N> graph, N from, Function2<N, N, V> weight, Numeric<V> evidence$1) {
        Numeric num = (Numeric)Predef$.MODULE$.implicitly(evidence$1);
        if (((Traversable)graph.adjacent().apply(from)).isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        int nodesCount = graph.nodesCount();
        HashSet explored = new HashSet();
        HashMap distance = new HashMap();
        Ordering ordering = new Ordering<Tuple3<N, N, V>>(num, distance){
            private final Numeric num$3;
            private final HashMap distance$4;
            {
                this.num$3 = num$6;
                this.distance$4 = distance$7;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }

            public int compare(Tuple3 x, Tuple3 y) {
                return this.num$3.toInt(this.num$3.minus(this.num$3.plus(this.distance$4.apply(x._1()), x._3()), this.num$3.plus(this.distance$4.apply(y._1()), y._3())));
            }
        };
        MinHeap outgoingEdges = new MinHeap(Math.min(graph.nodesCount(), 1024), ordering);
        ObjectRef head = ObjectRef.create(from);
        explored.add(from);
        distance.update(from, num.zero());
        ObjectRef nextEdges = ObjectRef.create(((Traversable)graph.adjacent().apply(from)).filterNot(explored).map((Function1 & Serializable)node -> Tuple3$.MODULE$.apply(from, node, weight.apply(from, node))));
        outgoingEdges.insert((Traversable)nextEdges.elem);
        do {
            outgoingEdges.extract().foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                Tuple3 tuple3 = x$12;
                if (tuple3 != null) {
                    Object t = tuple3._1();
                    Object h = tuple3._2();
                    Object w = tuple3._3();
                    explored.add(h);
                    distance.update(h, num.plus(distance.apply(t), w));
                    outgoingEdges.remove((Function1 & Serializable)x$1 -> {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 != null) {
                            Object node = tuple3._2();
                            return BoxesRunTime.equals((Object)node, (Object)h);
                        }
                        throw new MatchError((Object)tuple3);
                    });
                    nextEdges$2.elem = ((Traversable)graph.adjacent().apply(h)).filterNot(explored).map((Function1 & Serializable)node -> Tuple3$.MODULE$.apply(h, node, weight.apply(h, node)));
                    outgoingEdges.insert((Traversable)nextEdges$2.elem);
                    head$2.elem = h;
                    return;
                }
                throw new MatchError((Object)tuple3);
            });
        } while (!outgoingEdges.isEmpty() && explored.size() != nodesCount);
        return distance;
    }

    private final Tuple2 parseNodeAdjacentList$1(String line) {
        Object[] tokens = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(line), '\t');
        if (tokens.length == 0) {
            return null;
        }
        int label = Integer.parseInt(tokens[0]);
        Object object = Predef$.MODULE$.refArrayOps(tokens);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(object, 1));
        ArraySeq adjacent = ArraySeq$.MODULE$.unsafeWrapArray(ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$5 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$5)), ClassTag$.MODULE$.apply(Integer.TYPE)));
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)label), (Object)adjacent);
    }

    private final Tuple2 parseNodeWeightAdjacentList$1(String line) {
        Object[] tokens = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(line), '\t');
        if (tokens.length == 0) {
            return null;
        }
        int label = Integer.parseInt(tokens[0]);
        Object object = Predef$.MODULE$.refArrayOps(tokens);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(object, 1));
        scala.collection.immutable.Map adjacent = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)token -> this.parseNodeWeight$1((String)token), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)label), (Object)adjacent);
    }

    private final Tuple2 parseNodeWeight$1(String token) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(token), ','));
        int[] nw = (int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$6 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$6)), ClassTag$.MODULE$.apply(Integer.TYPE));
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nw[0]), (Object)BoxesRunTime.boxToInteger((int)nw[1]));
    }

    private final void checkCycles$1(scala.collection.mutable.Map marks$4, Graph graph$6, Object node2) {
        if (BoxesRunTime.unboxToChar((Object)marks$4.apply(node2)) == 'x') {
            throw Graph$GraphCycleFoundException$.MODULE$;
        }
        if (BoxesRunTime.unboxToChar((Object)marks$4.apply(node2)) == '0') {
            marks$4.update(node2, (Object)BoxesRunTime.boxToCharacter((char)'x'));
            ((Traversable)graph$6.adjacent().apply(node2)).foreach((JProcedure1 & Serializable)node -> this.checkCycles$1(marks$4, graph$6, node));
            marks$4.update(node2, (Object)BoxesRunTime.boxToCharacter((char)'1'));
            return;
        }
    }

    private final Queue randomizedQueue$1(Traversable seq) {
        Queue queue = (Queue)Queue$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        seq.foreach((Function1 & Serializable)n -> {
            if (Random$.MODULE$.nextBoolean()) {
                return (Queue)queue.append(n);
            }
            return (Queue)queue.prepend(n);
        });
        return queue;
    }

    private final Graph reversed$lzyINIT1$1(LazyRef reversed$lzy1$1, Graph graph$8) {
        Graph graph;
        LazyRef lazyRef = reversed$lzy1$1;
        synchronized (lazyRef) {
            graph = (Graph)(reversed$lzy1$1.initialized() ? reversed$lzy1$1.value() : reversed$lzy1$1.initialize(graph$8.reverse()));
        }
        return graph;
    }

    private final Graph reversed$3(LazyRef reversed$lzy1$2, Graph graph$9) {
        return (Graph)(reversed$lzy1$2.initialized() ? reversed$lzy1$2.value() : this.reversed$lzyINIT1$1(reversed$lzy1$2, graph$9));
    }

    private final Graph reversed$lzyINIT2$1(LazyRef reversed$lzy2$1, Graph graph$10) {
        Graph graph;
        LazyRef lazyRef = reversed$lzy2$1;
        synchronized (lazyRef) {
            graph = (Graph)(reversed$lzy2$1.initialized() ? reversed$lzy2$1.value() : reversed$lzy2$1.initialize(graph$10.reverse()));
        }
        return graph;
    }

    private final Graph reversed$4(LazyRef reversed$lzy2$2, Graph graph$11) {
        return (Graph)(reversed$lzy2$2.initialized() ? reversed$lzy2$2.value() : this.reversed$lzyINIT2$1(reversed$lzy2$2, graph$11));
    }
}

