/*
 * Decompiled with CFR 0.152.
 */
package org.encalmo.data;

import java.io.Serializable;
import org.encalmo.data.GenericGraph;
import org.encalmo.data.Graph;
import org.encalmo.data.Mutable;
import org.encalmo.data.MutableMapGraph$;
import org.encalmo.data.Traversable;
import org.encalmo.data.Traversable$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Shrinkable;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MutableMapGraph<N>
implements GenericGraph<N>,
Mutable<N> {
    private final Map<N, ArrayBuffer<N>> nodeMap;
    private final Function1<N, Traversable<N>> adjacent;

    public static <N> HashMap<N, ArrayBuffer<N>> $lessinit$greater$default$1() {
        return MutableMapGraph$.MODULE$.$lessinit$greater$default$1();
    }

    public MutableMapGraph(Map<N, ArrayBuffer<N>> nodeMap) {
        this.nodeMap = nodeMap;
        Growable.$init$((Growable)this);
        Shrinkable.$init$((Shrinkable)this);
        this.adjacent = nodeMap.view().mapValues((Function1 & Serializable)v -> {
            Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
            return new Traversable.TraversableFromIterable(v);
        });
    }

    public Map<N, ArrayBuffer<N>> nodeMap() {
        return this.nodeMap;
    }

    @Override
    public final Traversable<N> nodes() {
        Traversable.fromIterable fromIterable_this = Traversable$.MODULE$.fromIterable();
        Iterable x$proxy3 = this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().keys();
        return new Traversable.TraversableFromIterable(x$proxy3);
    }

    @Override
    public final int nodesCount() {
        return this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().size();
    }

    @Override
    public final boolean contains(N node) {
        return this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().contains(node);
    }

    @Override
    public Function1<N, Traversable<N>> adjacent() {
        return this.adjacent;
    }

    @Override
    public boolean hasAdjacent(N node) {
        return this.nodeMap().get(node).exists((Function1 & Serializable)_$3 -> _$3.nonEmpty());
    }

    @Override
    public Graph<N> reverse() {
        Graph.ReversedMutableMapGraph MutableMapGraph_this = new Graph.ReversedMutableMapGraph(this);
        Traversable edges$proxy3 = this.edges();
        edges$proxy3.foreach((Function1 & Serializable)edge -> (MutableMapGraph)MutableMapGraph_this.$plus$eq(edge.swap()));
        return MutableMapGraph_this;
    }

    public final MutableMapGraph addOne(Tuple2<N, N> edge) {
        ((ArrayBuffer)this.nodeMap().getOrElseUpdate(edge._1(), MutableMapGraph::addOne$$anonfun$1)).addOne(edge._2());
        this.nodeMap().getOrElseUpdate(edge._2(), MutableMapGraph::addOne$$anonfun$2);
        return this;
    }

    public final MutableMapGraph prependOne(Tuple2<N, N> edge) {
        ((ArrayBuffer)this.nodeMap().getOrElseUpdate(edge._1(), MutableMapGraph::prependOne$$anonfun$1)).prepend(edge._2());
        this.nodeMap().getOrElseUpdate(edge._2(), MutableMapGraph::prependOne$$anonfun$2);
        return this;
    }

    public final MutableMapGraph prependOneIfNotExist(Tuple2<N, N> edge) {
        this.nodeMap().updateWith(edge._1(), (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ArrayBuffer existing = (ArrayBuffer)((Some)option).value();
                if (!existing.contains(edge._2())) {
                    return Some$.MODULE$.apply((Object)existing.prepend(edge._2()));
                }
                return Some$.MODULE$.apply((Object)existing);
            }
            if (None$.MODULE$.equals(option)) {
                return Some$.MODULE$.apply(ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{edge._2()})));
            }
            throw new MatchError((Object)option);
        });
        this.nodeMap().updateWith(edge._2(), (Function1 & Serializable)_$4 -> _$4.orElse(MutableMapGraph::prependOneIfNotExist$$anonfun$2$$anonfun$1));
        return this;
    }

    public final MutableMapGraph subtractOne(Tuple2<N, N> edge) {
        this.nodeMap().get(edge._1()).foreach((Function1 & Serializable)adjacent -> {
            ArrayBuffer a = adjacent;
            return (ArrayBuffer)a.$minus$eq(edge._2());
        });
        return this;
    }

    @Override
    public final MutableMapGraph remove(N node) {
        this.nodeMap().subtractOne(node);
        return this;
    }

    @Override
    public final MutableMapGraph transform(Function2<N, ArrayBuffer<N>, ArrayBuffer<N>> f) {
        this.nodeMap().mapValuesInPlace(f);
        return this;
    }

    @Override
    public final MutableMapGraph update(N node, ArrayBuffer<N> adjacent) {
        this.nodeMap().update(node, adjacent);
        return this;
    }

    public final Tuple2<N, ArrayBuffer<N>> head() {
        return (Tuple2)this.nodeMap().head();
    }

    public final void clear() {
        this.org$encalmo$data$MutableMapGraph$$inline$nodeMap().clear();
    }

    public final MutableMapGraph<N> merge(MutableMapGraph<N> other) {
        if (other.nodeMap().isEmpty()) {
            return this;
        }
        if (this.nodeMap().isEmpty()) {
            return other;
        }
        HashMap mergedNodeMap = new HashMap();
        this.nodeMap().foreach((Function1 & Serializable)elem -> mergedNodeMap.addOne(elem));
        other.nodeMap().foreach((Function1 & Serializable)x$12 -> {
            Object object = x$12._1();
            ArrayBuffer arrayBuffer = (ArrayBuffer)x$12._2();
            return mergedNodeMap.updateWith(object, (Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    ArrayBuffer existing = (ArrayBuffer)((Some)option).value();
                    if (arrayBuffer.isEmpty()) {
                        return Some$.MODULE$.apply((Object)existing);
                    }
                    if (existing.isEmpty()) {
                        return Some$.MODULE$.apply((Object)arrayBuffer);
                    }
                    ArrayBuffer adjacent = ArrayBuffer$.MODULE$.from((IterableOnce)existing);
                    arrayBuffer.foreach((Function1)(JProcedure1 & Serializable)n -> {
                        if (!adjacent.contains(n)) {
                            adjacent.addOne(n);
                            return;
                        }
                    });
                    return Some$.MODULE$.apply((Object)adjacent);
                }
                if (None$.MODULE$.equals(option)) {
                    return Some$.MODULE$.apply((Object)arrayBuffer);
                }
                throw new MatchError((Object)option);
            });
        });
        return new MutableMapGraph<N>(mergedNodeMap);
    }

    public Map<N, ArrayBuffer<N>> org$encalmo$data$MutableMapGraph$$inline$nodeMap() {
        return this.nodeMap();
    }

    private static final ArrayBuffer addOne$$anonfun$1() {
        return new ArrayBuffer();
    }

    private static final ArrayBuffer addOne$$anonfun$2() {
        return new ArrayBuffer();
    }

    private static final ArrayBuffer prependOne$$anonfun$1() {
        return new ArrayBuffer();
    }

    private static final ArrayBuffer prependOne$$anonfun$2() {
        return new ArrayBuffer();
    }

    private static final Option prependOneIfNotExist$$anonfun$2$$anonfun$1() {
        return Some$.MODULE$.apply((Object)ArrayBuffer$.MODULE$.empty());
    }
}

