/*
 * Decompiled with CFR 0.152.
 */
package org.encalmo.aws;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Base64;
import org.encalmo.aws.AwsClient;
import scala.;
import scala.$less$colon$less$;
import scala.Int$;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.ChecksumMode;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;

public final class AwsS3Api$
implements Serializable {
    public static final AwsS3Api$ MODULE$ = new AwsS3Api$();

    private AwsS3Api$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AwsS3Api$.class);
    }

    public scala.collection.immutable.Map<String, String> getObjectMetadata(String bucketName, String objectKey, AwsClient aws) {
        scala.collection.immutable.Map result = this.body$proxy1$1(aws, bucketName, objectKey);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"getObjectMetadata");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)result);
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public HeadObjectResponse headObject(String bucketName, String objectKey, AwsClient aws) {
        HeadObjectResponse result = this.body$proxy2$1(aws, bucketName, objectKey);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"headObject");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)result);
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public boolean checkObjectExists(String bucketName, String objectKey, AwsClient aws) {
        boolean result = this.body$proxy3$1(bucketName, objectKey, aws);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"checkObjectExists");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)result));
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public boolean checkObjectNotExists(String bucketName, String objectKey, AwsClient aws) {
        boolean result = this.body$proxy4$1(bucketName, objectKey, aws);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"checkObjectNotExists");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)result));
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public InputStream getObjectInputStream(String bucketName, String objectKey, AwsClient aws) {
        InputStream result = this.body$proxy5$1(aws, bucketName, objectKey);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"getObjectInputStream");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)result);
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public PutObjectResponse putObjectUsingByteArray(String bucketName, String objectKey, byte[] bytes, scala.collection.immutable.Map<String, String> metadata, AwsClient aws) {
        PutObjectResponse result = this.body$proxy6$1(aws, bucketName, objectKey, metadata, bytes);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"putObjectUsingByteArray");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)result);
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public scala.collection.immutable.Map<String, String> putObjectUsingByteArray$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public PutObjectResponse putObjectUsingByteBuffer(String bucketName, String objectKey, ByteBuffer buffer, scala.collection.immutable.Map<String, String> metadata, AwsClient aws) {
        PutObjectResponse result = this.body$proxy7$1(aws, bucketName, objectKey, metadata, buffer);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"putObjectUsingByteBuffer");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)result);
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public scala.collection.immutable.Map<String, String> putObjectUsingByteBuffer$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public PutObjectResponse putObjectUsingPath(String bucketName, String objectKey, Path path, scala.collection.immutable.Map<String, String> metadata, AwsClient aws) {
        PutObjectResponse result = this.body$proxy8$1(aws, bucketName, objectKey, metadata, path);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"putObjectUsingPath");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)result);
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public scala.collection.immutable.Map<String, String> putObjectUsingPath$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public String createPresignedGetUrl(String bucketName, String objectKey, int durationMinutes, AwsClient aws) {
        String result = this.body$proxy9$1(bucketName, objectKey, durationMinutes);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"createPresignedGetUrl");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)result);
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public String createPresignedPutUrl(String bucketName, String objectKey, int durationMinutes, scala.collection.immutable.Map<String, String> metadata, AwsClient aws) {
        String result = this.body$proxy10$1(bucketName, objectKey, metadata, durationMinutes);
        if (aws.isDebugMode()) {
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)"[AwsClient] ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.print((Object)"createPresignedPutUrl");
            Predef$.MODULE$.print((Object)"\u001b[0m");
            Predef$.MODULE$.print((Object)"\u001b[33m");
            Predef$.MODULE$.print((Object)" returned ");
            Predef$.MODULE$.print((Object)"\u001b[36m");
            Predef$.MODULE$.println((Object)result);
            Predef$.MODULE$.print((Object)"\u001b[0m");
        }
        return result;
    }

    public scala.collection.immutable.Map<String, String> createPresignedPutUrl$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    private final scala.collection.immutable.Map body$proxy1$1(AwsClient aws$1, String bucketName$1, String objectKey$1) {
        return CollectionConverters$.MODULE$.MapHasAsScala(((GetObjectResponse)aws$1.s3().getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucketName$1).key(objectKey$1).build()).response()).metadata()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final HeadObjectResponse body$proxy2$1(AwsClient aws$2, String bucketName$2, String objectKey$2) {
        return aws$2.s3().headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName$2).key(objectKey$2).build());
    }

    private final boolean body$proxy3$1(String bucketName$3, String objectKey$3, AwsClient aws$3) {
        boolean bl;
        try {
            this.headObject(bucketName$3, objectKey$3, aws$3);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private final boolean body$proxy4$1(String bucketName$4, String objectKey$4, AwsClient aws$4) {
        boolean bl;
        try {
            this.headObject(bucketName$4, objectKey$4, aws$4);
            bl = false;
        }
        catch (Throwable throwable) {
            bl = true;
        }
        return bl;
    }

    private final InputStream body$proxy5$1(AwsClient aws$5, String bucketName$5, String objectKey$5) {
        return aws$5.s3().getObjectAsBytes((GetObjectRequest)GetObjectRequest.builder().bucket(bucketName$5).key(objectKey$5).checksumMode(ChecksumMode.ENABLED).build()).asInputStream();
    }

    private final PutObjectResponse body$proxy6$1(AwsClient aws$6, String bucketName$6, String objectKey$6, scala.collection.immutable.Map metadata$1, byte[] bytes$1) {
        return aws$6.s3().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(bucketName$6).key(objectKey$6).metadata(CollectionConverters$.MODULE$.MapHasAsJava((Map)metadata$1).asJava()).checksumAlgorithm(ChecksumAlgorithm.SHA256).checksumSHA256(new String(Base64.getEncoder().encode(MessageDigest.getInstance("SHA-256").digest(bytes$1)))).build(), RequestBody.fromBytes((byte[])bytes$1));
    }

    private final PutObjectResponse body$proxy7$1(AwsClient aws$7, String bucketName$7, String objectKey$7, scala.collection.immutable.Map metadata$2, ByteBuffer buffer$1) {
        return aws$7.s3().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(bucketName$7).key(objectKey$7).metadata(CollectionConverters$.MODULE$.MapHasAsJava((Map)metadata$2).asJava()).build(), RequestBody.fromByteBuffer((ByteBuffer)buffer$1));
    }

    private final PutObjectResponse body$proxy8$1(AwsClient aws$8, String bucketName$8, String objectKey$8, scala.collection.immutable.Map metadata$3, Path path$1) {
        return aws$8.s3().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(bucketName$8).key(objectKey$8).metadata(CollectionConverters$.MODULE$.MapHasAsJava((Map)metadata$3).asJava()).build(), RequestBody.fromFile((Path)path$1));
    }

    private final String body$proxy9$1(String bucketName$9, String objectKey$9, int durationMinutes$1) {
        S3Presigner presigner = S3Presigner.create();
        GetObjectRequest objectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName$9).key(objectKey$9).build();
        GetObjectPresignRequest presignRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofMinutes(Int$.MODULE$.int2long(durationMinutes$1))).getObjectRequest(objectRequest).build();
        PresignedGetObjectRequest presignedRequest = presigner.presignGetObject(presignRequest);
        return presignedRequest.url().toExternalForm();
    }

    private final String body$proxy10$1(String bucketName$10, String objectKey$10, scala.collection.immutable.Map metadata$4, int durationMinutes$2) {
        S3Presigner presigner = S3Presigner.create();
        PutObjectRequest objectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName$10).key(objectKey$10).metadata(CollectionConverters$.MODULE$.MapHasAsJava((Map)metadata$4).asJava()).build();
        PutObjectPresignRequest presignRequest = PutObjectPresignRequest.builder().signatureDuration(Duration.ofMinutes(Int$.MODULE$.int2long(durationMinutes$2))).putObjectRequest(objectRequest).build();
        PresignedPutObjectRequest presignedRequest = presigner.presignPutObject(presignRequest);
        return presignedRequest.url().toExternalForm();
    }
}

