/*
 * Decompiled with CFR 0.152.
 */
package org.encalmo.lambda;

import java.io.Serializable;
import munit.Assertions;
import munit.Compare$;
import munit.Location;
import munit.diff.DiffOptions$;
import munit.internal.console.Lines;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;
import ujson.Bool;
import ujson.Bool$;
import ujson.Num;
import ujson.Num$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Str;
import ujson.Str$;
import ujson.Value;
import upickle.core.LinkedHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JsonAssertions$
implements Assertions,
Serializable {
    private static Lines munitLines;
    private static ListBuffer munit$Assertions$$munitCapturedClues;
    public static final JsonAssertions$ MODULE$;

    private JsonAssertions$() {
    }

    static {
        MODULE$ = new JsonAssertions$();
        Assertions.$init$((Assertions)MODULE$);
        Statics.releaseFence();
    }

    public Lines munitLines() {
        return munitLines;
    }

    public ListBuffer munit$Assertions$$munitCapturedClues() {
        return munit$Assertions$$munitCapturedClues;
    }

    public void munit$Assertions$_setter_$munitLines_$eq(Lines x$0) {
        munitLines = x$0;
    }

    public void munit$Assertions$_setter_$munit$Assertions$$munitCapturedClues_$eq(ListBuffer x$0) {
        munit$Assertions$$munitCapturedClues = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonAssertions$.class);
    }

    public final String getStringAt(Value value, String path, Location x$3) {
        Value value2 = this.lookupJsonPath(value, value, path, x$3);
        if (value2 instanceof Str) {
            String string;
            Str str = Str$.MODULE$.unapply((Str)value2);
            String value3 = string = str._1();
            return value3;
        }
        Value other = value2;
        throw this.fail(new StringBuilder(42).append("Expected JSON string at path [").append(path).append("] but found ").append(other).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
    }

    public final int getIntAt(Value value, String path, Location x$3) {
        Value value2 = this.lookupJsonPath(value, value, path, x$3);
        if (value2 instanceof Num) {
            int n;
            double d;
            Num num = Num$.MODULE$.unapply((Num)value2);
            double value3 = d = num._1();
            try {
                n = (int)value3;
            }
            catch (Exception e) {
                throw this.fail(new StringBuilder(38).append("Expected integer at path [").append(path).append("] but found ").append(value3).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
            }
            return n;
        }
        Value other = value2;
        throw this.fail(new StringBuilder(42).append("Expected JSON number at path [").append(path).append("] but found ").append(other).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
    }

    public final int getStringOrIntAt(Value value, String path, Location x$3) {
        Value value2 = this.lookupJsonPath(value, value, path, x$3);
        if (value2 instanceof Str) {
            int n;
            String string;
            Str str = Str$.MODULE$.unapply((Str)value2);
            String value3 = string = str._1();
            try {
                n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value3));
            }
            catch (Exception e) {
                throw this.fail(new StringBuilder(45).append("Expected integer string at path [").append(path).append("] but found ").append(value3).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
            }
            return n;
        }
        if (value2 instanceof Num) {
            int n;
            double d;
            Num num = Num$.MODULE$.unapply((Num)value2);
            double value4 = d = num._1();
            try {
                n = (int)value4;
            }
            catch (Exception e) {
                throw this.fail(new StringBuilder(45).append("Expected integer number at path [").append(path).append("] but found ").append(value4).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
            }
            return n;
        }
        Value other = value2;
        throw this.fail(new StringBuilder(62).append("Expected JSON integer (string or number) at path [").append(path).append("] but found ").append(other).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
    }

    public final boolean getBooleanAt(Value value, String path, Location x$3) {
        Some some;
        Value value2 = this.lookupJsonPath(value, value, path, x$3);
        if (value2 instanceof Bool && !(some = Bool$.MODULE$.unapply((Bool)value2)).isEmpty()) {
            boolean bl;
            boolean value3 = bl = BoxesRunTime.unboxToBoolean((Object)some.get());
            return value3;
        }
        Value other = value2;
        throw this.fail(new StringBuilder(43).append("Expected JSON boolean at path [").append(path).append("] but found ").append(other).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
    }

    public final double getDoubleAt(Value value, String path, Location x$3) {
        Value value2 = this.lookupJsonPath(value, value, path, x$3);
        if (value2 instanceof Num) {
            double d;
            Num num = Num$.MODULE$.unapply((Num)value2);
            double value3 = d = num._1();
            return value3;
        }
        Value other = value2;
        throw this.fail(new StringBuilder(42).append("Expected JSON number at path [").append(path).append("] but found ").append(other).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
    }

    public final BigDecimal getBigDecimalAt(Value value, String path, Location x$3) {
        Value value2 = this.lookupJsonPath(value, value, path, x$3);
        if (value2 instanceof Num) {
            double d;
            Num num = Num$.MODULE$.unapply((Num)value2);
            double value3 = d = num._1();
            return package$.MODULE$.BigDecimal().apply(value3);
        }
        if (value2 instanceof Str) {
            String string;
            Str str = Str$.MODULE$.unapply((Str)value2);
            String value4 = string = str._1();
            return package$.MODULE$.BigDecimal().apply(value4);
        }
        Value other = value2;
        throw this.fail(new StringBuilder(43).append("Expected JSON decimal at path [").append(path).append("] but found ").append(other).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
    }

    public final Value assertObjectExistsAt(Value value, String path, Location x$3) {
        Value value2 = this.lookupJsonPath(value, value, path, x$3);
        if (value2 instanceof Obj) {
            Obj obj = (Obj)value2;
            return value;
        }
        Value other = value2;
        throw this.fail(new StringBuilder(42).append("Expected JSON object at path [").append(path).append("] but found ").append(other).toString(), this.fail$default$2(), x$3, DiffOptions$.MODULE$.default());
    }

    public final Value assertObjectAt(Value value, String path, Function1<Obj, BoxedUnit> check, Location x$4) {
        Value value2 = this.lookupJsonPath(value, value, path, x$4);
        if (value2 instanceof Obj) {
            Obj obj = (Obj)value2;
            check.apply((Object)obj);
            return value;
        }
        Value other = value2;
        throw this.fail(new StringBuilder(42).append("Expected JSON object at path [").append(path).append("] but found ").append(other).toString(), this.fail$default$2(), x$4, DiffOptions$.MODULE$.default());
    }

    public final Value assertObjectIfExistsAt(Value value, String path, Function1<Obj, BoxedUnit> check, Location x$4) {
        Value value2 = this.lookupJsonPath(value, value, path, x$4);
        if (value2 instanceof Obj) {
            Obj obj = (Obj)value2;
            check.apply((Object)obj);
            return value;
        }
        Value other = value2;
        return value;
    }

    public final Value assertStringExistsAt(Value value, String path, Location x$3) {
        this.getStringAt(value, path, x$3);
        return value;
    }

    public final Value assertStringAt(Value value, String path, String expected, Location x$4) {
        String arg = this.getStringAt(value, path, x$4);
        this.assertEquals(arg, expected, () -> JsonAssertions$.assertStringAt$$anonfun$1(expected, path, arg), x$4, Compare$.MODULE$.compareSubtypeWithSupertype((.less.colon.less)$less$colon$less$.MODULE$.refl()), DiffOptions$.MODULE$.default());
        return value;
    }

    public final Value assertStringAt(Value value, String path, Function1<String, Object> check, Location x$4) {
        String arg = this.getStringAt(value, path, x$4);
        this.assert(() -> JsonAssertions$.assertStringAt$$anonfun$2(check, arg), () -> JsonAssertions$.assertStringAt$$anonfun$3(path, arg), x$4);
        return value;
    }

    public final Value assertBooleanExistsAt(Value value, String path, Location x$3) {
        this.getBooleanAt(value, path, x$3);
        return value;
    }

    public final Value assertBooleanAt(Value value, String path, boolean expected, Location x$4) {
        boolean arg = this.getBooleanAt(value, path, x$4);
        this.assertEquals(BoxesRunTime.boxToBoolean((boolean)arg), BoxesRunTime.boxToBoolean((boolean)expected), () -> JsonAssertions$.assertBooleanAt$$anonfun$1(expected, path, arg), x$4, Compare$.MODULE$.compareSubtypeWithSupertype((.less.colon.less)$less$colon$less$.MODULE$.refl()), DiffOptions$.MODULE$.default());
        return value;
    }

    public final Value assertTrueAt(Value value, String path, Location x$3) {
        boolean arg = this.getBooleanAt(value, path, x$3);
        this.assertEquals(BoxesRunTime.boxToBoolean((boolean)arg), BoxesRunTime.boxToBoolean((boolean)true), () -> JsonAssertions$.assertTrueAt$$anonfun$1(path, arg), x$3, Compare$.MODULE$.compareSubtypeWithSupertype((.less.colon.less)$less$colon$less$.MODULE$.refl()), DiffOptions$.MODULE$.default());
        return value;
    }

    public final Value assertFalseAt(Value value, String path, Location x$3) {
        boolean arg = this.getBooleanAt(value, path, x$3);
        this.assertEquals(BoxesRunTime.boxToBoolean((boolean)arg), BoxesRunTime.boxToBoolean((boolean)false), () -> JsonAssertions$.assertFalseAt$$anonfun$1(path, arg), x$3, Compare$.MODULE$.compareSubtypeWithSupertype((.less.colon.less)$less$colon$less$.MODULE$.refl()), DiffOptions$.MODULE$.default());
        return value;
    }

    public final Value assertIntExistsAt(Value value, String path, Location x$3) {
        this.getIntAt(value, path, x$3);
        return value;
    }

    public final Value assertIntAt(Value value, String path, int expected, Location x$4) {
        int arg = this.getIntAt(value, path, x$4);
        this.assertEquals(BoxesRunTime.boxToInteger((int)arg), BoxesRunTime.boxToInteger((int)expected), () -> JsonAssertions$.assertIntAt$$anonfun$1(expected, path, arg), x$4, Compare$.MODULE$.compareSubtypeWithSupertype((.less.colon.less)$less$colon$less$.MODULE$.refl()), DiffOptions$.MODULE$.default());
        return value;
    }

    public final Value assertIntStringAt(Value value, String path, int expected, Location x$4) {
        int arg = this.getStringOrIntAt(value, path, x$4);
        this.assertEquals(BoxesRunTime.boxToInteger((int)arg), BoxesRunTime.boxToInteger((int)expected), () -> JsonAssertions$.assertIntStringAt$$anonfun$1(expected, path, arg), x$4, Compare$.MODULE$.compareSubtypeWithSupertype((.less.colon.less)$less$colon$less$.MODULE$.refl()), DiffOptions$.MODULE$.default());
        return value;
    }

    public final Value assertDoubleExistsAt(Value value, String path, Location x$3) {
        this.getDoubleAt(value, path, x$3);
        return value;
    }

    public final Value assertDoubleAt(Value value, String path, double expected, Location x$4) {
        double arg = this.getDoubleAt(value, path, x$4);
        this.assertEquals(BoxesRunTime.boxToDouble((double)arg), BoxesRunTime.boxToDouble((double)expected), () -> JsonAssertions$.assertDoubleAt$$anonfun$1(expected, path, arg), x$4, Compare$.MODULE$.compareSubtypeWithSupertype((.less.colon.less)$less$colon$less$.MODULE$.refl()), DiffOptions$.MODULE$.default());
        return value;
    }

    public final Value assertBigDecimalExistsAt(Value value, String path, Location x$3) {
        this.getBigDecimalAt(value, path, x$3);
        return value;
    }

    public final Value assertBigDecimalAt(Value value, String path, BigDecimal expected, Location x$4) {
        BigDecimal arg = this.getBigDecimalAt(value, path, x$4);
        this.assertEquals(arg, expected, () -> JsonAssertions$.assertBigDecimalAt$$anonfun$1(expected, path, arg), x$4, Compare$.MODULE$.compareSubtypeWithSupertype((.less.colon.less)$less$colon$less$.MODULE$.refl()), DiffOptions$.MODULE$.default());
        return value;
    }

    public final Value assertBigDecimalAt2(Value value, String path, Function1<BigDecimal, Object> check, Location x$4) {
        BigDecimal arg = this.getBigDecimalAt(value, path, x$4);
        this.assert(() -> JsonAssertions$.assertBigDecimalAt2$$anonfun$1(check, arg), () -> JsonAssertions$.assertBigDecimalAt2$$anonfun$2(path, arg), x$4);
        return value;
    }

    private Value lookupJsonPath(Value value, Value current, String path, Location x$4) {
        return this.lookupJsonPath(value, current, (Seq<String>)ArraySeq$.MODULE$.unsafeWrapArray((Object)path.split("\\.")), (Seq<String>)((Seq)package$.MODULE$.Seq().empty()), x$4);
    }

    private Value lookupJsonPath(Value value, Value current, Seq<String> path, Seq<String> breadcrumbs, Location x$5) {
        Value value2;
        while ((value2 = current) instanceof Obj) {
            LinkedHashMap linkedHashMap;
            Obj obj = Obj$.MODULE$.unapply((Obj)value2);
            LinkedHashMap map = linkedHashMap = obj._1();
            Option option = path.headOption();
            if (option instanceof Some) {
                String name = (String)((Some)option).value();
                if (map.contains((Object)name)) {
                    Value nestedValue = (Value)map.apply((Object)name);
                    if (((SeqOps)path.tail()).isEmpty()) {
                        return nestedValue;
                    }
                    Value value3 = nestedValue;
                    Seq seq = (Seq)path.tail();
                    Seq seq2 = (Seq)breadcrumbs.$colon$plus((Object)name);
                    current = value3;
                    path = seq;
                    breadcrumbs = seq2;
                    continue;
                }
                throw this.fail(new StringBuilder(47).append("JSON object").append(breadcrumbs.isEmpty() ? "" : new StringBuilder(4).append(" at ").append(breadcrumbs.mkString(".")).toString()).append(" does NOT contain property [").append(name).append("], see:\n").append(ujson.package$.MODULE$.write(current, 2, ujson.package$.MODULE$.write$default$3(), ujson.package$.MODULE$.write$default$4())).toString(), this.fail$default$2(), x$5, DiffOptions$.MODULE$.default());
            }
            if (None$.MODULE$.equals(option)) {
                return current;
            }
            throw new MatchError((Object)option);
        }
        Value other = value2;
        throw this.fail(new StringBuilder(40).append("Expected JSON object at path ").append(breadcrumbs.mkString(".")).append(" but found ").append(other).toString(), this.fail$default$2(), x$5, DiffOptions$.MODULE$.default());
    }

    private Option<Value> lookupMaybeJsonPath(Value value, Value current, String path, Location x$4) {
        return this.lookupMaybeJsonPath(value, current, (Seq<String>)ArraySeq$.MODULE$.unsafeWrapArray((Object)path.split("\\.")), (Seq<String>)((Seq)package$.MODULE$.Seq().empty()), x$4);
    }

    private Option<Value> lookupMaybeJsonPath(Value value, Value current, Seq<String> path, Seq<String> breadcrumbs, Location x$5) {
        Value value2;
        while ((value2 = current) instanceof Obj) {
            LinkedHashMap linkedHashMap;
            Obj obj = Obj$.MODULE$.unapply((Obj)value2);
            LinkedHashMap map = linkedHashMap = obj._1();
            Option option = path.headOption();
            if (option instanceof Some) {
                String name = (String)((Some)option).value();
                if (map.contains((Object)name)) {
                    Value nestedValue = (Value)map.apply((Object)name);
                    if (((SeqOps)path.tail()).isEmpty()) {
                        return Some$.MODULE$.apply((Object)nestedValue);
                    }
                    Value value3 = nestedValue;
                    Seq seq = (Seq)path.tail();
                    Seq seq2 = (Seq)breadcrumbs.$colon$plus((Object)name);
                    current = value3;
                    path = seq;
                    breadcrumbs = seq2;
                    continue;
                }
                return None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                return Some$.MODULE$.apply((Object)current);
            }
            throw new MatchError((Object)option);
        }
        Value other = value2;
        return None$.MODULE$;
    }

    private static final Object assertStringAt$$anonfun$1(String expected$1, String path$1, String arg$1) {
        return new StringBuilder(40).append("string `").append(expected$1).append("` expected at path [").append(path$1).append("] but got '").append(arg$1).append("'").toString();
    }

    private static final boolean assertStringAt$$anonfun$2(Function1 check$1, String arg$2) {
        return BoxesRunTime.unboxToBoolean((Object)check$1.apply((Object)arg$2));
    }

    private static final Object assertStringAt$$anonfun$3(String path$2, String arg$3) {
        return new StringBuilder(43).append("valid string expected at path [").append(path$2).append("] but got '").append(arg$3).append("'").toString();
    }

    private static final Object assertBooleanAt$$anonfun$1(boolean expected$2, String path$3, boolean arg$4) {
        return new StringBuilder(44).append("boolean `").append(expected$2).append("` expected at at path [").append(path$3).append("] but got '").append(arg$4).append("'").toString();
    }

    private static final Object assertTrueAt$$anonfun$1(String path$4, boolean arg$5) {
        return new StringBuilder(48).append("boolean `true` expected at at path [").append(path$4).append("] but got '").append(arg$5).append("'").toString();
    }

    private static final Object assertFalseAt$$anonfun$1(String path$5, boolean arg$6) {
        return new StringBuilder(49).append("boolean `false` expected at at path [").append(path$5).append("] but got '").append(arg$6).append("'").toString();
    }

    private static final Object assertIntAt$$anonfun$1(int expected$3, String path$6, int arg$7) {
        return new StringBuilder(41).append("integer `").append(expected$3).append("` expected at path [").append(path$6).append("] but got '").append(arg$7).append("'").toString();
    }

    private static final Object assertIntStringAt$$anonfun$1(int expected$4, String path$7, int arg$8) {
        return new StringBuilder(41).append("integer `").append(expected$4).append("` expected at path [").append(path$7).append("] but got '").append(arg$8).append("'").toString();
    }

    private static final Object assertDoubleAt$$anonfun$1(double expected$5, String path$8, double arg$9) {
        return new StringBuilder(40).append("number `").append(expected$5).append("` expected at path [").append(path$8).append("] but got '").append(arg$9).append("'").toString();
    }

    private static final Object assertBigDecimalAt$$anonfun$1(BigDecimal expected$6, String path$9, BigDecimal arg$10) {
        return new StringBuilder(41).append("decimal `").append(expected$6).append("` expected at path [").append(path$9).append("] but got '").append(arg$10).append("'").toString();
    }

    private static final boolean assertBigDecimalAt2$$anonfun$1(Function1 check$2, BigDecimal arg$11) {
        return BoxesRunTime.unboxToBoolean((Object)check$2.apply((Object)arg$11));
    }

    private static final Object assertBigDecimalAt2$$anonfun$2(String path$10, BigDecimal arg$12) {
        return new StringBuilder(44).append("valid decimal expected at path [").append(path$10).append("] but got '").append(arg$12).append("'").toString();
    }
}

