/*
 * Decompiled with CFR 0.152.
 */
package org.encalmo.utils;

import java.io.Serializable;
import org.encalmo.utils.HttpFormatter$;
import org.encalmo.utils.JsonFormatter$;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sttp.client4.BasicBody;
import sttp.client4.Request;
import sttp.client4.Response;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.MediaType;
import sttp.model.Method;
import sttp.model.StatusCode$;
import ujson.Arr;
import ujson.Arr$;
import ujson.Bool;
import ujson.Bool$;
import ujson.Null$;
import ujson.Num;
import ujson.Num$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Str;
import ujson.Str$;
import ujson.Value;
import upickle.core.LinkedHashMap;

public final class HttpieFormatter$
implements Serializable {
    private static final Set httpHeadersNotToShow;
    private static final Set<String> maskedHeaders;
    public static final HttpieFormatter$ MODULE$;

    private HttpieFormatter$() {
    }

    static {
        MODULE$ = new HttpieFormatter$();
        AnsiConsole.systemInstall();
        httpHeadersNotToShow = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"accept-encoding", "content-length"}));
        maskedHeaders = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"X-API-KEY", "AUTHORIZATION", "X-Meridian-Api-Key", "X-API-Key"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpieFormatter$.class);
    }

    public Set<String> httpHeadersNotToShow() {
        return httpHeadersNotToShow;
    }

    public <T> String showRequest(Request<T> request, Ansi ansi, boolean masked) {
        Ansi ansi2;
        String contentType = (String)request.header("Content-Type").getOrElse(HttpieFormatter$::$anonfun$1);
        BasicBody basicBody = request.body();
        if (basicBody instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)basicBody);
            String string = stringBody._1();
            String string2 = stringBody._2();
            MediaType mediaType = stringBody._3();
            String content = string;
            if (contentType.contains("application/json")) {
                this.showHttpieCommand(request, ansi, masked);
                Value json = JsonFormatter$.MODULE$.parse(content);
                if (json != null && !json.isNull()) {
                    ansi.fg(Ansi.Color.YELLOW).a(" \\\n  ").reset();
                    this.showJsonAsCommandLineAttributes(json, (Option<String>)None$.MODULE$, ansi, this.showJsonAsCommandLineAttributes$default$4());
                    ansi2 = BoxedUnit.UNIT;
                } else {
                    ansi2 = BoxedUnit.UNIT;
                }
            } else {
                String content2 = string;
                ansi.fg(Ansi.Color.YELLOW).a("echo '").fg(Ansi.Color.BLUE).a(content2).fg(Ansi.Color.YELLOW).a("' | \\").newline().reset();
                ansi2 = this.showHttpieCommand(request, ansi, masked);
            }
        } else {
            BasicBody other = basicBody;
            ansi2 = this.showHttpieCommand(request, ansi, masked);
        }
        ansi.newline().newline();
        HttpFormatter$.MODULE$.showRequest(request, ansi, masked);
        return ansi.toString();
    }

    public boolean showRequest$default$3() {
        return false;
    }

    private <T> Ansi showHttpieCommand(Request<T> request, Ansi ansi, boolean masked) {
        ansi.fgBrightYellow().bold().a("http").boldOff().fg(Ansi.Color.YELLOW).a(" -v ").a((Object)new Method(request.method())).a(" ").fgBrightCyan().bold().a((Object)request.uri()).boldOff().fg(Ansi.Color.YELLOW);
        Seq headers = (Seq)((IterableOps)((SeqOps)request.headers().filterNot((Function1 & Serializable)h -> h.name().startsWith(":") || MODULE$.httpHeadersNotToShow().contains((Object)h.name().toLowerCase()))).sortBy((Function1 & Serializable)_$1 -> _$1.name(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)_$2 -> MODULE$.maskHeader((Header)_$2, masked));
        if (headers.nonEmpty()) {
            headers.foreach((Function1 & Serializable)h -> {
                ansi.fg(Ansi.Color.YELLOW).a(" \\\n  ");
                return ansi.fg(Ansi.Color.BLUE).a("'").a(h.name()).a(":").fgBrightBlue().a(h.value()).fg(Ansi.Color.BLUE).a("'");
            });
        }
        return ansi.reset();
    }

    private Header maskHeader(Header header, boolean shouldMask) {
        if (shouldMask && maskedHeaders.contains((Object)header.name().toUpperCase())) {
            return Header$.MODULE$.apply(header.name(), header.value().replaceAll(".", "X"));
        }
        return header;
    }

    public <T> String showResponse(Response<T> response, Ansi ansi) {
        return HttpFormatter$.MODULE$.showResponse(response, ansi);
    }

    private Ansi.Color colorOfResponse(int statusCode) {
        if (StatusCode$.MODULE$.isSuccess$extension(statusCode)) {
            return Ansi.Color.GREEN;
        }
        if (StatusCode$.MODULE$.isClientError$extension(statusCode) || StatusCode$.MODULE$.isServerError$extension(statusCode)) {
            return Ansi.Color.RED;
        }
        return Ansi.Color.BLUE;
    }

    private Ansi showJsonAsCommandLineAttributes(Value value, Option<String> nestedPath, Ansi ansi, String separator) {
        Some some;
        Value value2 = value;
        if (value2 instanceof Str) {
            String string;
            Str str = Str$.MODULE$.unapply((Str)value2);
            String v = string = str._1();
            return ansi.fg(Ansi.Color.BLUE).a("=").fg(Ansi.Color.CYAN).a(v).a("'").reset();
        }
        if (value2 instanceof Num) {
            double d;
            Num num = Num$.MODULE$.unapply((Num)value2);
            double v = d = num._1();
            return ansi.fg(Ansi.Color.BLUE).a(":=").fg(Ansi.Color.MAGENTA).a(JsonFormatter$.MODULE$.numberFormattter().format(v)).a("'").reset();
        }
        if (value2 instanceof Bool && !(some = Bool$.MODULE$.unapply((Bool)value2)).isEmpty()) {
            boolean bl;
            boolean v = bl = BoxesRunTime.unboxToBoolean((Object)some.get());
            return ansi.fg(Ansi.Color.BLUE).a(":=").fg(v ? Ansi.Color.GREEN : Ansi.Color.RED).a(v).a("'").reset();
        }
        if (Null$.MODULE$.equals(value2)) {
            return ansi.fg(Ansi.Color.BLUE).a(":=").a("null").a("'").reset();
        }
        if (value2 instanceof Arr) {
            ArrayBuffer arrayBuffer;
            Arr arr = Arr$.MODULE$.unapply((Arr)value2);
            ArrayBuffer array = arrayBuffer = arr._1();
            ((IterableOnceOps)array.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Ansi ansi;
                    Value v = (Value)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    Value value = v;
                    if (value instanceof Obj || value instanceof Arr) {
                        ansi = this.showJsonAsCommandLineAttributes(v, (Option<String>)nestedPath.map((Function1 & Serializable)_$3 -> new StringBuilder(0).append((String)_$3).append(new StringBuilder(2).append("[").append(index).append("]").toString()).toString()).orElse(() -> HttpieFormatter$.showJsonAsCommandLineAttributes$$anonfun$1$$anonfun$2(index)), ansi, this.showJsonAsCommandLineAttributes$default$4());
                    } else {
                        Ansi ansi2;
                        Option option = nestedPath;
                        if (option instanceof Some) {
                            String path = (String)((Some)option).value();
                            ansi2 = ansi.fg(Ansi.Color.YELLOW).a(path).a("[").a(index).a("]");
                        } else if (None$.MODULE$.equals(option)) {
                            ansi2 = ansi.fg(Ansi.Color.YELLOW).a("'").a("[").a(index).a("]");
                        } else {
                            throw new MatchError((Object)option);
                        }
                        ansi = this.showJsonAsCommandLineAttributes(v, nestedPath, ansi, this.showJsonAsCommandLineAttributes$default$4());
                    }
                    if (index < array.size() - 1) {
                        ansi.fg(Ansi.Color.YELLOW).a(separator);
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return ansi;
        }
        if (value2 instanceof Obj) {
            LinkedHashMap linkedHashMap;
            Obj obj = Obj$.MODULE$.unapply((Obj)value2);
            LinkedHashMap fields = linkedHashMap = obj._1();
            ((IterableOnceOps)fields.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    Ansi ansi;
                    String name = (String)tuple2._1();
                    Value v = (Value)tuple2._2();
                    int index = BoxesRunTime.unboxToInt((Object)tuple22._2());
                    Value value = v;
                    if (value instanceof Obj || value instanceof Arr) {
                        ansi = this.showJsonAsCommandLineAttributes(v, (Option<String>)nestedPath.map((Function1 & Serializable)_$4 -> new StringBuilder(0).append((String)_$4).append(new StringBuilder(2).append("[").append(name).append("]").toString()).toString()).orElse(() -> HttpieFormatter$.showJsonAsCommandLineAttributes$$anonfun$2$$anonfun$2(name)), ansi, this.showJsonAsCommandLineAttributes$default$4());
                    } else {
                        Ansi ansi2;
                        Option option = nestedPath;
                        if (option instanceof Some) {
                            String path = (String)((Some)option).value();
                            ansi2 = ansi.fg(Ansi.Color.YELLOW).a(path).a("[").a(name).a("]");
                        } else if (None$.MODULE$.equals(option)) {
                            ansi2 = ansi.fg(Ansi.Color.YELLOW).a("'").a(name);
                        } else {
                            throw new MatchError((Object)option);
                        }
                        ansi = this.showJsonAsCommandLineAttributes(v, nestedPath, ansi, this.showJsonAsCommandLineAttributes$default$4());
                    }
                    if (index < fields.size() - 1) {
                        ansi.fg(Ansi.Color.YELLOW).a(separator);
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple22);
            });
            return ansi;
        }
        throw new MatchError((Object)value2);
    }

    private Option<String> showJsonAsCommandLineAttributes$default$2() {
        return None$.MODULE$;
    }

    private String showJsonAsCommandLineAttributes$default$4() {
        return " \\\n  ";
    }

    private static final String $anonfun$1() {
        return "";
    }

    private static final Option showJsonAsCommandLineAttributes$$anonfun$1$$anonfun$2(int index$2) {
        return Some$.MODULE$.apply((Object)new StringBuilder(3).append("'[").append(index$2).append("]").toString());
    }

    private static final Option showJsonAsCommandLineAttributes$$anonfun$2$$anonfun$2(String name$2) {
        return Some$.MODULE$.apply((Object)new StringBuilder(1).append("'").append(name$2).toString());
    }
}

