/*
 * Encog(tm) Artificial Intelligence Framework v2.3
 * Java Version
 * http://www.heatonresearch.com/encog/
 * http://code.google.com/p/encog-java/
 * 
 * Copyright 2008-2010 by Heaton Research Inc.
 * 
 * Released under the LGPL.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 * 
 * Encog and Heaton Research are Trademarks of Heaton Research, Inc.
 * For information on Heaton Research trademarks, visit:
 * 
 * http://www.heatonresearch.com/copyright.html
 */

package org.encog.neural.pattern;

/**
 * GUI constants for creating the patterns. Specifically default x and y
 * coordinates.
 * 
 * @author jheaton
 * 
 */
public final class PatternConst {

	/**
	 * The starting x-coordinate.
	 */
	public static final int START_X = 50;

	/**
	 * The starting y-coordinate.
	 */
	public static final int START_Y = 50;

	/**
	 * How much to indent on the x-axis.
	 */
	public static final int INDENT_X = 300;

	/**
	 * How much to increase y by as the network grows.
	 */
	public static final int INC_Y = 150;

	/**
	 * Private constructor.
	 */
	private PatternConst() {

	}
}
