/*
 * Encog(tm) Artificial Intelligence Framework v2.3
 * Java Version
 * http://www.heatonresearch.com/encog/
 * http://code.google.com/p/encog-java/
 * 
 * Copyright 2008-2010 by Heaton Research Inc.
 * 
 * Released under the LGPL.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 * 
 * Encog and Heaton Research are Trademarks of Heaton Research, Inc.
 * For information on Heaton Research trademarks, visit:
 * 
 * http://www.heatonresearch.com/copyright.html
 */

package org.encog.normalize.output;

/**
 * An output field, this represents the actual output from the 
 * normalization.  Output from the normalization class is usually
 * input to a neural network.
 *
 * An output field may contain several subfields that will be
 * generated.  Call getSubfieldCount to determine how many fields
 * will be generated.  A simple field will return 1, indicating that 
 * this is a single field.
 */
public interface OutputField {
	
	/**
	 * Calculate the value for this field.  Specify subfield of zero
	 * if this is a simple field.
	 * @param subfield The subfield index.
	 * @return The calculated value for this field.
	 */
	double calculate(int subfield);

	/**
	 * @return The numebr of fields that will actually be generated by 
	 * this field. For a simple field, this value is 1.
	 */
	int getSubfieldCount();

	/**
	 * @return Is this field part of the ideal data uses to train the
	 * neural network.
	 */
	boolean isIdeal();

	/**
	 * Init this field for a new row.
	 */
	void rowInit();

	/**
	 * Set whether this field is part of the ideal output for a network.
	 * @param ideal True if this field is ideal.
	 */
	void setIdeal(boolean ideal);
}
