/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.encog.bot.browse.Address;
import org.encog.bot.browse.BrowseError;
import org.encog.bot.browse.LoadWebPage;
import org.encog.bot.browse.WebPage;
import org.encog.bot.browse.range.DocumentRange;
import org.encog.bot.browse.range.Form;
import org.encog.bot.browse.range.FormElement;
import org.encog.bot.browse.range.Input;
import org.encog.bot.browse.range.Link;
import org.encog.util.http.FormUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser {
    private WebPage currentPage;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public WebPage getCurrentPage() {
        return this.currentPage;
    }

    public void navigate(Form form) {
        this.navigate(form, null);
    }

    public void navigate(Form form, Input submit) {
        try {
            InputStream is;
            URL targetURL;
            OutputStream os;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Posting a form");
            }
            URLConnection connection = null;
            if (form.getMethod() == Form.Method.GET) {
                os = new ByteArrayOutputStream();
            } else {
                connection = form.getAction().getUrl().openConnection();
                os = connection.getOutputStream();
            }
            FormUtility formData = new FormUtility(os, null);
            for (DocumentRange dr : form.getElements()) {
                FormElement element;
                if (!(dr instanceof FormElement) || (element = (FormElement)dr) != submit && !element.isAutoSend()) continue;
                String name = element.getName();
                String value = element.getValue();
                if (name == null) continue;
                if (value == null) {
                    value = "";
                }
                formData.add(name, value);
            }
            if (form.getMethod() == Form.Method.GET) {
                String action = form.getAction().getUrl().toString();
                os.close();
                action = action + "?";
                action = action + os.toString();
                targetURL = new URL(action);
                connection = targetURL.openConnection();
                is = connection.getInputStream();
            } else {
                targetURL = form.getAction().getUrl();
                os.close();
                is = connection.getInputStream();
            }
            this.navigate(targetURL, is);
            is.close();
        }
        catch (IOException e) {
            throw new BrowseError(e);
        }
    }

    public void navigate(Link link) {
        Address address = link.getTarget();
        if (address.getUrl() != null) {
            this.navigate(address.getUrl());
        } else {
            this.navigate(address.getOriginal());
        }
    }

    public void navigate(String url) {
        try {
            this.navigate(new URL(url));
        }
        catch (MalformedURLException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)e);
            }
            throw new BrowseError(e);
        }
    }

    public void navigate(URL url) {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Navigating to page:" + url);
            }
            URLConnection connection = url.openConnection();
            InputStream is = connection.getInputStream();
            this.navigate(url, is);
            is.close();
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)e);
            }
            throw new BrowseError(e);
        }
    }

    public void navigate(URL url, InputStream is) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("POSTing to page:" + url);
        }
        LoadWebPage load = new LoadWebPage(url);
        this.currentPage = load.load(is);
    }

    public void setCurrentPage(WebPage currentPage) {
        this.currentPage = currentPage;
    }
}

