/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.rss;

import java.util.Date;
import org.encog.bot.rss.RSS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSSItem {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String title;
    private String link;
    private String description;
    private Date date;

    public Date getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLink() {
        return this.link;
    }

    public String getTitle() {
        return this.title;
    }

    public void load(Node node) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String str;
            Node n = nl.item(i);
            String name = n.getNodeName();
            if (name.equalsIgnoreCase("title")) {
                this.title = RSS.getXMLText(n);
                continue;
            }
            if (name.equalsIgnoreCase("link")) {
                this.link = RSS.getXMLText(n);
                continue;
            }
            if (name.equalsIgnoreCase("description")) {
                this.description = RSS.getXMLText(n);
                continue;
            }
            if (!name.equalsIgnoreCase("pubDate") || (str = RSS.getXMLText(n)) == null) continue;
            this.date = RSS.parseDate(str);
        }
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        builder.append("title=\"");
        builder.append(this.title);
        builder.append("\",link=\"");
        builder.append(this.link);
        builder.append("\",date=\"");
        builder.append(this.date);
        builder.append("\"]");
        return builder.toString();
    }
}

