/*
 * Decompiled with CFR 0.152.
 */
package org.encog.cloud;

import java.util.HashMap;
import org.encog.cloud.CloudRequest;
import org.encog.cloud.EncogCloud;
import org.encog.cloud.EncogCloudError;

public class CloudTask {
    private final EncogCloud cloud;
    private String taskURL;

    public CloudTask(EncogCloud cloud) {
        this.cloud = cloud;
    }

    public EncogCloud getCloud() {
        return this.cloud;
    }

    public void init(String name) {
        if (this.cloud.getSession() == null) {
            throw new EncogCloudError("Session must be established before a task is created.");
        }
        CloudRequest request = new CloudRequest();
        String url = this.cloud.getSession();
        url = url + "task/create";
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("name", name);
        args.put("status", "Starting...");
        request.performURLPOST(false, url, args);
        this.taskURL = this.cloud.getSession() + "task/" + request.getResponseProperty("id") + "/";
    }

    public void setStatus(String status) {
        if (this.taskURL == null) {
            throw new EncogCloudError("Can't set status for inactive task.");
        }
        CloudRequest request = new CloudRequest();
        String url = this.taskURL + "update";
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("status", status);
        request.performURLPOST(true, url, args);
    }

    public void stop(String finalStatus) {
        if (this.taskURL == null) {
            throw new EncogCloudError("Can't stop inactive task.");
        }
        CloudRequest request = new CloudRequest();
        String url = this.taskURL + "update";
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("status", finalStatus);
        request.performURLPOST(false, url, args);
        url = this.taskURL + "stop";
        request = new CloudRequest();
        request.performURLGET(false, url);
    }
}

